/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class FloatArrayProperty
extends DefinedProperty {
    private final float[] value;

    FloatArrayProperty(int propertyKeyId, float[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public float[] value() {
        return (float[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof float[]) {
            return Arrays.equals(this.value, (float[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((FloatArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(4 + SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

