/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.HitCounter;
import org.neo4j.kernel.impl.cache.ReferenceWithKey;
import org.neo4j.kernel.impl.cache.ReferenceWithKeyQueue;

public class ReferenceCache<E extends EntityWithSizeObject>
implements Cache<E> {
    private final ConcurrentHashMap<Long, ReferenceWithKey<Long, E>> cache = new ConcurrentHashMap();
    private final ReferenceWithKeyQueue<Long, E> refQueue = new ReferenceWithKeyQueue();
    private final String name;
    private final HitCounter counter = new HitCounter();
    private final ReferenceWithKey.Factory referenceFactory;

    ReferenceCache(String name, ReferenceWithKey.Factory referenceFactory) {
        this.name = name;
        this.referenceFactory = referenceFactory;
    }

    @Override
    public E put(E value) {
        ReferenceWithKey<Long, E> previous;
        Long key = value.getId();
        ReferenceWithKey<Long, E> ref = this.referenceFactory.newReference(key, value, this.refQueue);
        while ((previous = this.cache.putIfAbsent(key, ref)) != null) {
            EntityWithSizeObject prevValue = (EntityWithSizeObject)previous.get();
            if (prevValue == null) {
                this.pollClearedValues();
                continue;
            }
            return (E)prevValue;
        }
        return value;
    }

    @Override
    public void putAll(Collection<E> entities) {
        HashMap<Long, ReferenceWithKey<Long, EntityWithSizeObject>> softMap = new HashMap<Long, ReferenceWithKey<Long, EntityWithSizeObject>>(entities.size() * 2);
        for (EntityWithSizeObject entity : entities) {
            Long key = entity.getId();
            ReferenceWithKey<Long, EntityWithSizeObject> ref = this.referenceFactory.newReference(key, entity, this.refQueue);
            softMap.put(key, ref);
        }
        this.cache.putAll(softMap);
        this.pollClearedValues();
    }

    @Override
    public E get(long key) {
        ReferenceWithKey<Long, E> ref = this.cache.get(key);
        if (ref != null) {
            EntityWithSizeObject value = (EntityWithSizeObject)ref.get();
            if (value == null) {
                this.cache.remove(key);
            }
            return (E)this.counter.count(value);
        }
        return (E)((EntityWithSizeObject)this.counter.count(null));
    }

    @Override
    public E remove(long key) {
        ReferenceWithKey<Long, E> ref = this.cache.remove(key);
        if (ref != null) {
            return (E)((EntityWithSizeObject)ref.get());
        }
        return null;
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long hitCount() {
        return this.counter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.counter.getMissCount();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void updateSize(E entity, int newSize) {
    }

    @Override
    public void printStatistics() {
    }

    private void pollClearedValues() {
        ReferenceWithKey<Long, E> clearedValue = this.refQueue.safePoll();
        while (clearedValue != null) {
            this.cache.remove(clearedValue.key());
            clearedValue = this.refQueue.safePoll();
        }
    }
}

