/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.StringLogger;

public class NeoStore
extends AbstractStore {
    public static final String TYPE_DESCRIPTOR = "NeoStore";
    public static final int RECORD_SIZE = 9;
    public static final String DEFAULT_NAME = "neostore";
    private static final int TIME_POSITION = 0;
    private static final int RANDOM_POSITION = 1;
    private static final int VERSION_POSITION = 2;
    private static final int LATEST_TX_POSITION = 3;
    private static final int STORE_VERSION_POSITION = 4;
    private static final int NEXT_GRAPH_PROP_POSITION = 5;
    private static final int LATEST_CONSTRAINT_TX_POSITION = 6;
    private NodeStore nodeStore;
    private PropertyStore propStore;
    private RelationshipStore relStore;
    private RelationshipTypeTokenStore relTypeStore;
    private LabelTokenStore labelTokenStore;
    private SchemaStore schemaStore;
    private RelationshipGroupStore relGroupStore;
    private final RemoteTxHook txHook;
    private AtomicLong lastCommittedTx = new AtomicLong(-1L);
    private AtomicLong latestConstraintIntroducingTx = new AtomicLong(-1L);
    private final int denseNodeThreshold;
    private final int REL_GRAB_SIZE;

    public static boolean isStorePresent(FileSystemAbstraction fs, Config config) {
        File neoStore = config.get(CommonAbstractStore.Configuration.neo_store);
        return fs.fileExists(neoStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeoStore(File fileName, Config conf, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, RemoteTxHook txHook, RelationshipTypeTokenStore relTypeStore, LabelTokenStore labelTokenStore, PropertyStore propStore, RelationshipStore relStore, NodeStore nodeStore, SchemaStore schemaStore, RelationshipGroupStore relGroupStore) {
        super(fileName, conf, IdType.NEOSTORE_BLOCK, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
        this.relTypeStore = relTypeStore;
        this.labelTokenStore = labelTokenStore;
        this.propStore = propStore;
        this.relStore = relStore;
        this.nodeStore = nodeStore;
        this.schemaStore = schemaStore;
        this.relGroupStore = relGroupStore;
        this.REL_GRAB_SIZE = conf.get(Configuration.relationship_grab_size);
        this.txHook = txHook;
        this.denseNodeThreshold = conf.get(Configuration.dense_node_threshold);
        this.setRecovered();
        try {
            if (this.getCreationTime() != 0L && this.getStoreVersion() == 0L) {
                this.setStoreVersion(NeoStore.versionStringToLong("v0.A.3"));
                this.updateHighId();
            }
        }
        finally {
            this.unsetRecovered();
        }
    }

    @Override
    protected void checkVersion() {
        try {
            String foundVersion;
            this.verifyCorrectTypeDescriptorAndVersion();
            if (!this.getStoreOk() && !"v0.A.3".equals(foundVersion = NeoStore.versionLongToString(NeoStore.getStoreVersion(this.fileSystemAbstraction, this.configuration.get(CommonAbstractStore.Configuration.neo_store))))) {
                throw new IllegalStateException(String.format("Mismatching store version found (%s while expecting %s). The store cannot be automatically upgraded since it isn't cleanly shutdown. Recover by starting the database using the previous Neo4j version, followed by a clean shutdown. Then start with this version again.", foundVersion, "v0.A.3"));
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        super.verifyFileSizeAndTruncate();
        if (this.getFileChannel().size() == 45L) {
            this.insertRecord(5, -1L);
            this.registerIdFromUpdateRecord(5L);
        }
        if (this.getFileChannel().size() == 54L) {
            this.insertRecord(6, 0L);
            this.registerIdFromUpdateRecord(6L);
        }
    }

    private void insertRecord(int recordPosition, long value) throws IOException {
        try {
            StoreChannel channel = this.getFileChannel();
            long previousPosition = channel.position();
            channel.position(9 * recordPosition);
            int trail = (int)(channel.size() - channel.position());
            ByteBuffer trailBuffer = null;
            if (trail > 0) {
                trailBuffer = ByteBuffer.allocate(trail);
                channel.read(trailBuffer);
                trailBuffer.flip();
            }
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.put(Record.IN_USE.byteValue());
            buffer.putLong(value);
            buffer.flip();
            channel.position(9 * recordPosition);
            channel.write(buffer);
            if (trail > 0) {
                channel.write(trailBuffer);
            }
            channel.position(previousPosition);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void closeStorage() {
        if (this.relTypeStore != null) {
            this.relTypeStore.close();
            this.relTypeStore = null;
        }
        if (this.labelTokenStore != null) {
            this.labelTokenStore.close();
            this.labelTokenStore = null;
        }
        if (this.propStore != null) {
            this.propStore.close();
            this.propStore = null;
        }
        if (this.relStore != null) {
            this.relStore.close();
            this.relStore = null;
        }
        if (this.nodeStore != null) {
            this.nodeStore.close();
            this.nodeStore = null;
        }
        if (this.schemaStore != null) {
            this.schemaStore.close();
            this.schemaStore = null;
        }
        if (this.relGroupStore != null) {
            this.relGroupStore.close();
            this.relGroupStore = null;
        }
    }

    @Override
    public void flushAll() {
        if (this.relTypeStore == null || this.labelTokenStore == null || this.propStore == null || this.relStore == null || this.nodeStore == null || this.schemaStore == null || this.relGroupStore == null) {
            return;
        }
        super.flushAll();
        this.relTypeStore.flushAll();
        this.labelTokenStore.flushAll();
        this.propStore.flushAll();
        this.relStore.flushAll();
        this.nodeStore.flushAll();
        this.schemaStore.flushAll();
        this.relGroupStore.flushAll();
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public boolean freeIdsDuringRollback() {
        return this.txHook.freeIdsDuringRollback();
    }

    public static long setVersion(FileSystemAbstraction fileSystem, File neoStore, long version) {
        return NeoStore.setRecord(fileSystem, neoStore, 2, version);
    }

    public static long setStoreVersion(FileSystemAbstraction fileSystem, File neoStore, long storeVersion) {
        return NeoStore.setRecord(fileSystem, neoStore, 4, storeVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long setRecord(FileSystemAbstraction fileSystem, File neoStore, int position, long value) {
        try (StoreChannel channel = fileSystem.open(neoStore, "rw");){
            channel.position(9 * position + 1);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            channel.read(buffer);
            buffer.flip();
            long previous = buffer.getLong();
            channel.position(9 * position + 1);
            buffer.clear();
            buffer.putLong(value).flip();
            channel.write(buffer);
            long l = previous;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getStoreVersion(FileSystemAbstraction fs, File neoStore) {
        return NeoStore.getRecord(fs, neoStore, 4);
    }

    public static long getTxId(FileSystemAbstraction fs, File neoStore) {
        return NeoStore.getRecord(fs, neoStore, 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getRecord(FileSystemAbstraction fs, File neoStore, int recordPosition) {
        try (StoreChannel channel = fs.open(neoStore, "r");){
            if (recordPosition > 3 && channel.size() < 45L) {
                long l = -1L;
                return l;
            }
            channel.position(9 * recordPosition + 1);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            channel.read(buffer);
            buffer.flip();
            long l = buffer.getLong();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getStoreVersion());
    }

    public long getCreationTime() {
        return this.getRecord(0L);
    }

    public void setCreationTime(long time) {
        this.setRecord(0L, time);
    }

    public long getRandomNumber() {
        return this.getRecord(1L);
    }

    public void setRandomNumber(long nr) {
        this.setRecord(1L, nr);
    }

    public void setRecoveredStatus(boolean status) {
        if (status) {
            this.setRecovered();
            this.nodeStore.setRecovered();
            this.propStore.setRecovered();
            this.relStore.setRecovered();
            this.relTypeStore.setRecovered();
            this.labelTokenStore.setRecovered();
            this.schemaStore.setRecovered();
            this.relGroupStore.setRecovered();
        } else {
            this.unsetRecovered();
            this.nodeStore.unsetRecovered();
            this.propStore.unsetRecovered();
            this.relStore.unsetRecovered();
            this.relTypeStore.unsetRecovered();
            this.labelTokenStore.unsetRecovered();
            this.schemaStore.unsetRecovered();
            this.relGroupStore.unsetRecovered();
        }
    }

    public long getVersion() {
        return this.getRecord(2L);
    }

    public void setVersion(long version) {
        this.setRecord(2L, version);
    }

    public synchronized void setLastCommittedTx(long txId) {
        long current = this.getLastCommittedTx();
        if (current + 1L != txId && !this.isInRecoveryMode()) {
            throw new InvalidRecordException("Could not set tx commit id[" + txId + "] since the current one is[" + current + "]");
        }
        this.setRecord(3L, txId);
        this.lastCommittedTx.set(txId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastCommittedTx() {
        long txId = this.lastCommittedTx.get();
        if (txId == -1L) {
            NeoStore neoStore = this;
            synchronized (neoStore) {
                txId = this.getRecord(3L);
                this.lastCommittedTx.compareAndSet(-1L, txId);
            }
        }
        return txId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestConstraintIntroducingTx() {
        long txId = this.latestConstraintIntroducingTx.get();
        if (txId == -1L) {
            NeoStore neoStore = this;
            synchronized (neoStore) {
                txId = this.getRecord(6L);
                this.latestConstraintIntroducingTx.compareAndSet(-1L, txId);
            }
        }
        return txId;
    }

    public void setLatestConstraintIntroducingTx(long latestConstraintIntroducingTx) {
        this.setRecord(6L, latestConstraintIntroducingTx);
        this.latestConstraintIntroducingTx.set(latestConstraintIntroducingTx);
    }

    public long incrementVersion() {
        long current = this.getVersion();
        this.setVersion(current + 1L);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecord(long id, long value) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.put(Record.IN_USE.byteValue()).putLong(value);
            this.registerIdFromUpdateRecord(id);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public long getStoreVersion() {
        return this.getRecord(4L);
    }

    public void setStoreVersion(long version) {
        this.setRecord(4L, version);
    }

    public long getGraphNextProp() {
        return this.getRecord(5L);
    }

    public void setGraphNextProp(long propId) {
        this.setRecord(5L, propId);
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public SchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    public RelationshipStore getRelationshipStore() {
        return this.relStore;
    }

    public RelationshipTypeTokenStore getRelationshipTypeStore() {
        return this.relTypeStore;
    }

    public LabelTokenStore getLabelTokenStore() {
        return this.labelTokenStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propStore;
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.relGroupStore;
    }

    @Override
    public void makeStoreOk() {
        this.relTypeStore.makeStoreOk();
        this.labelTokenStore.makeStoreOk();
        this.propStore.makeStoreOk();
        this.relStore.makeStoreOk();
        this.nodeStore.makeStoreOk();
        this.schemaStore.makeStoreOk();
        this.relGroupStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.relTypeStore.rebuildIdGenerators();
        this.labelTokenStore.rebuildIdGenerators();
        this.propStore.rebuildIdGenerators();
        this.relStore.rebuildIdGenerators();
        this.nodeStore.rebuildIdGenerators();
        this.schemaStore.rebuildIdGenerators();
        this.relGroupStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.updateHighId();
        this.relTypeStore.updateIdGenerators();
        this.labelTokenStore.updateIdGenerators();
        this.propStore.updateIdGenerators();
        this.relStore.updateHighId();
        this.nodeStore.updateIdGenerators();
        this.schemaStore.updateHighId();
        this.relGroupStore.updateHighId();
    }

    public int getRelationshipGrabSize() {
        return this.REL_GRAB_SIZE;
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.addAll(this.nodeStore.getAllWindowPoolStats());
        list.addAll(this.propStore.getAllWindowPoolStats());
        list.addAll(this.relStore.getAllWindowPoolStats());
        list.addAll(this.relTypeStore.getAllWindowPoolStats());
        list.addAll(this.labelTokenStore.getAllWindowPoolStats());
        list.addAll(this.relGroupStore.getAllWindowPoolStats());
        return list;
    }

    @Override
    public void logAllWindowPoolStats(StringLogger.LineLogger logger) {
        super.logAllWindowPoolStats(logger);
        this.nodeStore.logAllWindowPoolStats(logger);
        this.relStore.logAllWindowPoolStats(logger);
        this.relTypeStore.logAllWindowPoolStats(logger);
        this.labelTokenStore.logAllWindowPoolStats(logger);
        this.propStore.logAllWindowPoolStats(logger);
        this.relGroupStore.logAllWindowPoolStats(logger);
    }

    public boolean isStoreOk() {
        return this.getStoreOk() && this.relTypeStore.getStoreOk() && this.labelTokenStore.getStoreOk() && this.propStore.getStoreOk() && this.relStore.getStoreOk() && this.nodeStore.getStoreOk() && this.schemaStore.getStoreOk() && this.relGroupStore.getStoreOk();
    }

    @Override
    public void logVersions(StringLogger.LineLogger msgLog) {
        msgLog.logLine("Store versions:");
        super.logVersions(msgLog);
        this.schemaStore.logVersions(msgLog);
        this.nodeStore.logVersions(msgLog);
        this.relStore.logVersions(msgLog);
        this.relTypeStore.logVersions(msgLog);
        this.labelTokenStore.logVersions(msgLog);
        this.propStore.logVersions(msgLog);
        this.relGroupStore.logVersions(msgLog);
        this.stringLogger.flush();
    }

    @Override
    public void logIdUsage(StringLogger.LineLogger msgLog) {
        msgLog.logLine("Id usage:");
        this.schemaStore.logIdUsage(msgLog);
        this.nodeStore.logIdUsage(msgLog);
        this.relStore.logIdUsage(msgLog);
        this.relTypeStore.logIdUsage(msgLog);
        this.labelTokenStore.logIdUsage(msgLog);
        this.propStore.logIdUsage(msgLog);
        this.relGroupStore.logIdUsage(msgLog);
        this.stringLogger.flush();
    }

    public NeoStoreRecord asRecord() {
        NeoStoreRecord result = new NeoStoreRecord();
        result.setNextProp(this.getRecord(5L));
        return result;
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Uknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits(8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put(c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Uknown";
        }
        Bits bits = Bits.bitsFromLongs(new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read in version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    public int getDenseNodeThreshold() {
        return this.getRelationshipGroupStore().getDenseNodeThreshold();
    }

    public static abstract class Configuration
    extends AbstractStore.Configuration {
        public static final Setting<Integer> relationship_grab_size = GraphDatabaseSettings.relationship_grab_size;
        public static final Setting<Integer> dense_node_threshold = GraphDatabaseSettings.dense_node_threshold;
    }
}

