/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Iterator;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.xa.PropertyTraverser;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;

public class PropertyCreator {
    private final PropertyStore propertyStore;
    private final PropertyTraverser traverser;

    public PropertyCreator(PropertyStore propertyStore, PropertyTraverser traverser) {
        this.propertyStore = propertyStore;
        this.traverser = traverser;
    }

    public <P extends PrimitiveRecord> void primitiveChangeProperty(RecordAccess.RecordProxy<Long, P, Void> primitiveRecordChange, int propertyKey, Object value, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        long propertyId = this.traverser.findPropertyRecordContaining(primitive, propertyKey, propertyRecords, true);
        PropertyRecord propertyRecord = propertyRecords.getOrLoad(propertyId, primitive).forChangingData();
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it has been deleted.");
        }
        PropertyBlock block = propertyRecord.getPropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        propertyRecord.setChanged(primitive);
        for (DynamicRecord record : block.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, block.getType().intValue());
            propertyRecord.addDeletedRecord(record);
        }
        this.propertyStore.encodeValue(block, propertyKey, value);
        if (propertyRecord.size() > PropertyType.getPayloadSize()) {
            propertyRecord.removePropertyBlock(propertyKey);
            this.addPropertyBlockToPrimitive(block, primitiveRecordChange, propertyRecords);
        }
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }

    public <P extends PrimitiveRecord> void primitiveAddProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord record = (PrimitiveRecord)primitive.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(record, propertyRecords));
        PropertyBlock block = new PropertyBlock();
        this.propertyStore.encodeValue(block, propertyKey, value);
        this.addPropertyBlockToPrimitive(block, primitive, propertyRecords);
        assert (this.traverser.assertPropertyChain(record, propertyRecords));
    }

    private <P extends PrimitiveRecord> void addPropertyBlockToPrimitive(PropertyBlock block, RecordAccess.RecordProxy<Long, P, Void> primitiveRecordChange, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        int newBlockSizeInBytes = block.getSize();
        PropertyRecord host = null;
        long firstProp = primitive.getNextProp();
        if (firstProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> change = propertyRecords.getOrLoad(firstProp, primitive);
            PropertyRecord propRecord = change.forReadingLinkage();
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            assert (propRecord.inUse()) : propRecord;
            int propSize = propRecord.size();
            assert (propSize > 0) : propRecord;
            if (propSize + newBlockSizeInBytes <= PropertyType.getPayloadSize()) {
                host = propRecord = change.forChangingData();
                host.addPropertyBlock(block);
                host.setChanged(primitive);
            }
        }
        if (host == null) {
            host = propertyRecords.create(this.propertyStore.nextId(), primitive).forChangingData();
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(host.getId());
                host.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(host.getId());
            host.addPropertyBlock(block);
            host.setInUse(true);
        }
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }

    public long createPropertyChain(PrimitiveRecord owner, Iterator<PropertyKeyAndValue> properties, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        if (properties == null || !properties.hasNext()) {
            return Record.NO_NEXT_PROPERTY.intValue();
        }
        PropertyRecord currentRecord = propertyRecords.create(this.propertyStore.nextId(), owner).forChangingData();
        currentRecord.setInUse(true);
        currentRecord.setCreated();
        PropertyRecord firstRecord = currentRecord;
        while (properties.hasNext()) {
            PropertyKeyAndValue property = properties.next();
            int keyId = property.getKey();
            PropertyBlock block = new PropertyBlock();
            this.propertyStore.encodeValue(block, keyId, property.getValue());
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                PropertyRecord prevRecord = currentRecord;
                long propertyId = this.propertyStore.nextId();
                currentRecord = propertyRecords.create(propertyId, owner).forChangingData();
                currentRecord.setInUse(true);
                currentRecord.setCreated();
                prevRecord.setNextProp(propertyId);
                currentRecord.setPrevProp(prevRecord.getId());
            }
            currentRecord.addPropertyBlock(block);
        }
        return firstRecord.getId();
    }

    public <P extends PrimitiveRecord> void setPrimitiveProperty(RecordAccess.RecordProxy<Long, P, Void> primitiveProxy, int key, Object value, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveProxy.forReadingLinkage();
        long nextProp = primitive.getNextProp();
        PropertyBlock block = new PropertyBlock();
        this.propertyStore.encodeValue(block, key, value);
        int size = block.getSize();
        RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> thatFits = null;
        RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> thatHas = null;
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue() && (thatHas == null || thatFits == null)) {
            RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> current = propertyRecords.getOrLoad(nextProp, primitive);
            if (thatHas == null && current.forReadingLinkage().getPropertyBlock(key) != null) {
                thatHas = current;
                PropertyBlock removed = thatHas.forChangingData().removePropertyBlock(key);
                for (DynamicRecord dynRec : removed.getValueRecords()) {
                    dynRec.setInUse(false);
                    thatHas.forChangingData().addDeletedRecord(dynRec);
                }
            }
            if (thatFits == null && PropertyType.getPayloadSize() - current.forReadingLinkage().size() >= size) {
                thatFits = current;
            }
            nextProp = current.forReadingLinkage().getNextProp();
        }
        if (thatFits == null) {
            thatFits = propertyRecords.create(this.propertyStore.nextId(), primitive);
            PropertyRecord thatFitsRecord = thatFits.forChangingData();
            thatFitsRecord.setInUse(true);
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord first = propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                thatFitsRecord.setNextProp(first.getId());
                first.setPrevProp(thatFitsRecord.getId());
            }
            ((PrimitiveRecord)primitiveProxy.forChangingLinkage()).setNextProp(thatFitsRecord.getId());
        }
        ((PropertyRecord)thatFits.forChangingData()).addPropertyBlock(block);
    }

    public static class PropertyKeyAndValue {
        private int key;
        private Object value;

        public void set(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

