/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyNodeStoreReader
implements Closeable {
    public static final String FROM_VERSION = "NodeStore v0.A.1";
    public static final int RECORD_SIZE = 14;
    private final StoreChannel fileChannel;
    private final long maxId;

    public LegacyNodeStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 14L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void accept(Visitor visitor) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(57344);
        long fileSize = this.fileChannel.size();
        for (long position = 0L; position < fileSize; position += (long)buffer.capacity()) {
            buffer.clear();
            this.fileChannel.read(buffer, position);
            for (int recordOffset = 0; recordOffset < buffer.capacity() && (long)recordOffset + position < fileSize; recordOffset += 14) {
                buffer.position(recordOffset);
                long id = (position + (long)recordOffset) / 14L;
                visitor.visit(this.readRecord(buffer, id));
            }
        }
    }

    private NodeRecord readRecord(ByteBuffer buffer, long id) {
        NodeRecord nodeRecord;
        boolean inUse;
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (inUse) {
            long nextRel = LegacyStore.getUnsignedInt(buffer);
            long relModifier = (inUseByte & 0xEL) << 31;
            long nextProp = LegacyStore.getUnsignedInt(buffer);
            long propModifier = (inUseByte & 0xF0L) << 28;
            long lsbLabels = LegacyStore.getUnsignedInt(buffer);
            long hsbLabels = buffer.get() & 0xFF;
            long labels = lsbLabels | hsbLabels << 32;
            nodeRecord = new NodeRecord(id, false, LegacyStore.longFromIntAndMod(nextRel, relModifier), LegacyStore.longFromIntAndMod(nextProp, propModifier));
            nodeRecord.setLabelField(labels, Collections.emptyList());
        } else {
            nodeRecord = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        nodeRecord.setInUse(inUse);
        return nodeRecord;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    public NodeRecord readNodeStore(long id) throws IOException {
        NodeRecord nodeRecord;
        boolean inUse;
        ByteBuffer buffer = ByteBuffer.allocateDirect(14);
        this.fileChannel.position(id * 14L);
        this.fileChannel.read(buffer);
        buffer.flip();
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (inUse) {
            long nextRel = LegacyStore.getUnsignedInt(buffer);
            long relModifier = (inUseByte & 0xEL) << 31;
            long nextProp = LegacyStore.getUnsignedInt(buffer);
            long propModifier = (inUseByte & 0xF0L) << 28;
            long lsbLabels = LegacyStore.getUnsignedInt(buffer);
            long hsbLabels = buffer.get() & 0xFF;
            long labels = lsbLabels | hsbLabels << 32;
            nodeRecord = new NodeRecord(id, false, LegacyStore.longFromIntAndMod(nextRel, relModifier), LegacyStore.longFromIntAndMod(nextProp, propModifier));
            nodeRecord.setLabelField(labels, Collections.emptyList());
        } else {
            nodeRecord = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        nodeRecord.setInUse(inUse);
        return nodeRecord;
    }

    public static interface Visitor {
        public void visit(NodeRecord var1);
    }
}

