/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.nioneo.store.AbstractSchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class IndexRule
extends AbstractSchemaRule {
    private static final long NO_OWNING_CONSTRAINT = -1L;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final int propertyKey;
    private final Long owningConstraint;

    static IndexRule readIndexRule(long id, boolean constraintIndex, int label, ByteBuffer serialized) {
        SchemaIndexProvider.Descriptor providerDescriptor = IndexRule.readProviderDescriptor(serialized);
        int propertyKeyId = IndexRule.readPropertyKey(serialized);
        if (constraintIndex) {
            long owningConstraint = IndexRule.readOwningConstraint(serialized);
            return IndexRule.constraintIndexRule(id, label, propertyKeyId, providerDescriptor, owningConstraint);
        }
        return IndexRule.indexRule(id, label, propertyKeyId, providerDescriptor);
    }

    public static IndexRule indexRule(long id, int label, int propertyKeyId, SchemaIndexProvider.Descriptor providerDescriptor) {
        return new IndexRule(id, label, propertyKeyId, providerDescriptor, null);
    }

    public static IndexRule constraintIndexRule(long id, int label, int propertyKeyId, SchemaIndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        return new IndexRule(id, label, propertyKeyId, providerDescriptor, owningConstraint == null ? -1L : owningConstraint);
    }

    public IndexRule(long id, int label, int propertyKey, SchemaIndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        super(id, label, IndexRule.indexKind(owningConstraint));
        this.owningConstraint = owningConstraint;
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        this.providerDescriptor = providerDescriptor;
        this.propertyKey = propertyKey;
    }

    private static SchemaRule.Kind indexKind(Long owningConstraint) {
        return owningConstraint == null ? SchemaRule.Kind.INDEX_RULE : SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
    }

    private static SchemaIndexProvider.Descriptor readProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom(serialized);
        String providerVersion = UTF8.getDecodedStringFrom(serialized);
        return new SchemaIndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static int readPropertyKey(ByteBuffer serialized) {
        short count = serialized.getShort();
        assert (count == 1);
        return IoPrimitiveUtils.safeCastLongToInt(serialized.getLong());
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public int getPropertyKey() {
        return this.propertyKey;
    }

    public boolean isConstraintIndex() {
        return this.owningConstraint != null;
    }

    public Long getOwningConstraint() {
        if (!this.isConstraintIndex()) {
            throw new IllegalStateException("Can only get owner from constraint indexes.");
        }
        if (this.owningConstraint == -1L) {
            return null;
        }
        return this.owningConstraint;
    }

    @Override
    public int length() {
        return super.length() + UTF8.computeRequiredByteBufferSize(this.providerDescriptor.getKey()) + UTF8.computeRequiredByteBufferSize(this.providerDescriptor.getVersion()) + 2 + 8 + (this.isConstraintIndex() ? 8 : 0);
    }

    @Override
    public void serialize(ByteBuffer target) {
        super.serialize(target);
        UTF8.putEncodedStringInto(this.providerDescriptor.getKey(), target);
        UTF8.putEncodedStringInto(this.providerDescriptor.getVersion(), target);
        target.putShort((short)1);
        target.putLong(this.propertyKey);
        if (this.isConstraintIndex()) {
            target.putLong(this.owningConstraint);
        }
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.propertyKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRule other = (IndexRule)obj;
        return this.propertyKey == other.propertyKey;
    }

    @Override
    protected String innerToString() {
        StringBuilder result = new StringBuilder(", provider=").append(this.providerDescriptor).append(", properties=").append(this.propertyKey);
        if (this.owningConstraint != null) {
            result.append(", owner=");
            if (this.owningConstraint == -1L) {
                result.append("<not set>");
            } else {
                result.append(this.owningConstraint);
            }
        }
        return result.toString();
    }

    public IndexRule withOwningConstraint(long constraintId) {
        if (!this.isConstraintIndex()) {
            throw new IllegalStateException(this + " is not a constraint index");
        }
        return IndexRule.constraintIndexRule(this.getId(), this.getLabel(), this.getPropertyKey(), this.getProviderDescriptor(), constraintId);
    }
}

