/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class VersionAwareLogEntryReader
implements LogEntryReader<ReadableByteChannel> {
    private static final short CURRENT_FORMAT_VERSION = 4;
    static final int LOG_HEADER_SIZE = 16;
    private ByteBuffer byteBuffer;
    private final XaCommandReaderFactory commandReaderFactory;

    public VersionAwareLogEntryReader(ByteBuffer byteBuffer, XaCommandReaderFactory commandReaderFactory) {
        this.byteBuffer = byteBuffer;
        this.commandReaderFactory = commandReaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] readLogHeader(FileSystemAbstraction fileSystem, File file) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "r");){
            long[] lArray = VersionAwareLogEntryReader.readLogHeader(ByteBuffer.allocateDirect(100000), channel, true);
            return lArray;
        }
    }

    public static long[] readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict) throws IOException {
        buffer.clear();
        buffer.limit(16);
        if (channel.read(buffer) != 16) {
            if (strict) {
                throw new IOException("Unable to read log version and last committed tx");
            }
            return null;
        }
        buffer.flip();
        long version = buffer.getLong();
        long previousCommittedTx = buffer.getLong();
        long logFormatVersion = version >> 56 & 0xFFL;
        if (strict && 4L != logFormatVersion || 4L < logFormatVersion) {
            throw new IllegalLogFormatException(4L, logFormatVersion);
        }
        return new long[]{version &= 0xFFFFFFFFFFFFFFL, previousCommittedTx};
    }

    public static ByteBuffer writeLogHeader(ByteBuffer buffer, long logVersion, long previousCommittedTxId) {
        buffer.clear();
        buffer.putLong(logVersion | 0x400000000000000L);
        buffer.putLong(previousCommittedTxId);
        buffer.flip();
        return buffer;
    }

    @Override
    public LogEntry readLogEntry(ReadableByteChannel channel) throws IOException {
        byte version = 0;
        this.byteBuffer.clear();
        this.byteBuffer.limit(1);
        if (channel.read(this.byteBuffer) != this.byteBuffer.limit()) {
            return null;
        }
        this.byteBuffer.flip();
        byte type = this.byteBuffer.get();
        if (type < 0) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(1);
            if (channel.read(this.byteBuffer) != this.byteBuffer.limit()) {
                return null;
            }
            this.byteBuffer.flip();
            version = type;
            type = this.byteBuffer.get();
        }
        try {
            switch (type) {
                case 1: {
                    return this.readTxStartEntry(version, channel);
                }
                case 2: {
                    return this.readTxPrepareEntry(version, channel);
                }
                case 5: {
                    return this.readTxOnePhaseCommitEntry(version, channel);
                }
                case 6: {
                    return this.readTxTwoPhaseCommitEntry(version, channel);
                }
                case 3: {
                    return this.readTxCommandEntry(version, channel);
                }
                case 4: {
                    return this.readTxDoneEntry(version, channel);
                }
                case 0: {
                    return null;
                }
            }
            throw new IOException("Unknown entry[" + type + "]");
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private LogEntry.Start readTxStartEntry(byte version, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        byte globalIdLength = this.readNextByte(channel);
        byte branchIdLength = this.readNextByte(channel);
        byte[] globalId = this.readIntoArray(channel, globalIdLength);
        byte[] branchId = this.readIntoArray(channel, branchIdLength);
        int identifier = this.readNextInt(channel);
        int formatId = this.readNextInt(channel);
        int masterId = this.readNextInt(channel);
        int myId = this.readNextInt(channel);
        long timeWritten = this.readNextLong(channel);
        long latestCommittedTxWhenStarted = this.readNextLong(channel);
        XidImpl xid = new XidImpl(globalId, branchId);
        return new LogEntry.Start(xid, identifier, version, masterId, myId, -1L, timeWritten, latestCommittedTxWhenStarted);
    }

    private LogEntry.Prepare readTxPrepareEntry(byte version, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Prepare(this.readNextInt(channel), version, this.readNextLong(channel));
    }

    private LogEntry.OnePhaseCommit readTxOnePhaseCommitEntry(byte version, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.OnePhaseCommit(this.readNextInt(channel), version, this.readNextLong(channel), this.readNextLong(channel));
    }

    private LogEntry.Done readTxDoneEntry(byte version, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Done(this.readNextInt(channel), version);
    }

    private LogEntry.TwoPhaseCommit readTxTwoPhaseCommitEntry(byte version, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.TwoPhaseCommit(this.readNextInt(channel), version, this.readNextLong(channel), this.readNextLong(channel));
    }

    private LogEntry.Command readTxCommandEntry(byte version, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        int identifier = this.readNextInt(channel);
        XaCommandReader commandReader = this.commandReaderFactory.newInstance(version, this.byteBuffer);
        XaCommand command = commandReader.read(channel);
        if (command == null) {
            return null;
        }
        return new LogEntry.Command(identifier, version, command);
    }

    private int readNextInt(ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return this.readIntoBufferAndFlip(channel, 4).getInt();
    }

    private long readNextLong(ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return this.readIntoBufferAndFlip(channel, 8).getLong();
    }

    public byte readNextByte(ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return this.readIntoBufferAndFlip(channel, 1).get();
    }

    private ByteBuffer readIntoBufferAndFlip(ReadableByteChannel channel, int numberOfBytes) throws IOException, ReadPastEndException {
        if (IoPrimitiveUtils.readAndFlip(channel, this.byteBuffer, numberOfBytes)) {
            return this.byteBuffer;
        }
        throw new ReadPastEndException();
    }

    private byte[] readIntoArray(ReadableByteChannel channel, int numberOfBytes) throws IOException, ReadPastEndException {
        byte[] result = new byte[numberOfBytes];
        if (IoPrimitiveUtils.readAndFlip(channel, this.byteBuffer, numberOfBytes)) {
            this.byteBuffer.get(result);
            return result;
        }
        throw new ReadPastEndException();
    }
}

