/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.util.List;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryVisitorAdapter;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.NoOpLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class XaFactory {
    private final Config config;
    private final TxIdGenerator txIdGenerator;
    private final AbstractTransactionManager txManager;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Monitors monitors;
    private final Logging logging;
    private final RecoveryVerifier recoveryVerifier;
    private final LogPruneStrategy pruneStrategy;
    private final KernelHealth kernelHealth;

    public XaFactory(Config config, TxIdGenerator txIdGenerator, AbstractTransactionManager txManager, FileSystemAbstraction fileSystemAbstraction, Monitors monitors, Logging logging, RecoveryVerifier recoveryVerifier, LogPruneStrategy pruneStrategy, KernelHealth kernelHealth) {
        this.config = config;
        this.txIdGenerator = txIdGenerator;
        this.txManager = txManager;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.monitors = monitors;
        this.logging = logging;
        this.recoveryVerifier = recoveryVerifier;
        this.pruneStrategy = pruneStrategy;
        this.kernelHealth = kernelHealth;
    }

    public XaContainer newXaContainer(XaDataSource xaDataSource, File logicalLog, XaCommandReaderFactory commandReaderFactory, XaCommandWriterFactory commandWriterFactory, InjectedTransactionValidator injectedTxValidator, XaTransactionFactory tf, TransactionStateFactory stateFactory, TransactionInterceptorProviders providers, boolean readOnly, Function<List<LogEntry>, List<LogEntry>> transactionTranslator) {
        XaLogicalLog log;
        if (logicalLog == null || commandReaderFactory == null || commandWriterFactory == null || tf == null) {
            throw new IllegalArgumentException("Null parameter, LogicalLog[" + logicalLog + "], CommandReaderFactory[" + commandReaderFactory + "CommandWriterFactory[" + commandWriterFactory + "], TransactionFactory[" + tf + "]");
        }
        XaResourceManager rm = new XaResourceManager(xaDataSource, tf, this.txIdGenerator, this.txManager, this.recoveryVerifier, logicalLog.getName(), this.monitors);
        long rotateAtSize = this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold);
        if (readOnly) {
            log = new NoOpLogicalLog(this.logging);
        } else {
            LogEntryVisitorAdapter interceptor = null;
            interceptor = providers.shouldInterceptDeserialized() && providers.hasAnyInterceptorConfigured() ? new LogEntryVisitorAdapter(providers, xaDataSource) : Functions.identity();
            log = new XaLogicalLog(logicalLog, rm, commandReaderFactory, commandWriterFactory, tf, this.fileSystemAbstraction, this.monitors, this.logging, this.pruneStrategy, stateFactory, this.kernelHealth, rotateAtSize, injectedTxValidator, interceptor, transactionTranslator);
        }
        rm.setLogicalLog(log);
        tf.setLogicalLog(log);
        return new XaContainer(rm, log);
    }
}

