/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;

public class Stage<INPUT> {
    private final List<Step<?>> pipeline = new ArrayList();
    private INPUT input;
    private Step<INPUT> inputStep;
    private final StageExecution execution;

    public Stage(Logging logging, String name, Configuration config) {
        this.execution = new StageExecution(logging, name, config, this.pipeline);
    }

    public void input(Step<INPUT> inputStep, INPUT input) {
        this.inputStep = inputStep;
        this.input = input;
        this.add(inputStep);
    }

    protected StageControl control() {
        return this.execution;
    }

    public void add(Step<?> step) {
        this.pipeline.add(step);
    }

    public StageExecution execute() throws Exception {
        this.linkSteps();
        this.inputStep.receive(1L, this.input);
        this.execution.start();
        return this.execution;
    }

    private void linkSteps() {
        Step<?> previous = null;
        for (Step<?> step : this.pipeline) {
            if (previous != null) {
                previous.setDownstream(step);
            }
            previous = step;
        }
    }
}

