/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInsertDocTest {
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void insert() {
        BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example", (FileSystemAbstraction)this.fileSystem);
        Label personLabel = DynamicLabel.label((String)"Person");
        inserter.createDeferredSchemaIndex(personLabel).on("name").create();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "Mattias");
        long mattiasNode = inserter.createNode(properties, new Label[]{personLabel});
        properties.put("name", "Chris");
        long chrisNode = inserter.createNode(properties, new Label[]{personLabel});
        DynamicRelationshipType knows = DynamicRelationshipType.withName((String)"KNOWS");
        inserter.createRelationship(mattiasNode, chrisNode, (RelationshipType)knows, null);
        inserter.shutdown();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fileSystem).newImpermanentDatabase("target/batchinserter-example");
        try (Transaction tx = db.beginTx();){
            Node mNode = db.getNodeById(mattiasNode);
            Node cNode = mNode.getSingleRelationship((RelationshipType)knows, Direction.OUTGOING).getEndNode();
            Assert.assertThat((Object)((String)cNode.getProperty("name")), (Matcher)Is.is((Object)"Chris"));
            Assert.assertThat((Object)db.schema().getIndexes(personLabel).iterator().hasNext(), (Matcher)Is.is((Object)true));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void insertWithConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("neostore.nodestore.db.mapped_memory", "90M");
        BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example-config", (FileSystemAbstraction)this.fileSystem, config);
        inserter.shutdown();
    }

    @Test
    public void insertWithConfigFile() throws IOException {
        try (Writer fw = this.fileSystem.openAsWriter(new File("target/batchinsert-config"), "utf-8", false);){
            fw.append("neostore.nodestore.db.mapped_memory=90M\nneostore.relationshipstore.db.mapped_memory=3G\nneostore.propertystore.db.mapped_memory=50M\nneostore.propertystore.db.strings.mapped_memory=100M\nneostore.propertystore.db.arrays.mapped_memory=0M");
        }
        var2_2 = null;
        try (InputStream input = this.fileSystem.openAsInputStream(new File("target/batchinsert-config"));){
            Map config = MapUtil.load((InputStream)input);
            BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example-config", (FileSystemAbstraction)this.fileSystem, (Map)config);
            inserter.shutdown();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchDb() {
        GraphDatabaseService batchDb = BatchInserters.batchDatabase((String)"target/batchdb-example", (FileSystemAbstraction)this.fileSystem);
        Label personLabel = DynamicLabel.label((String)"Person");
        Node mattiasNode = batchDb.createNode(new Label[]{personLabel});
        mattiasNode.setProperty("name", (Object)"Mattias");
        Node chrisNode = batchDb.createNode();
        chrisNode.setProperty("name", (Object)"Chris");
        chrisNode.addLabel(personLabel);
        DynamicRelationshipType knows = DynamicRelationshipType.withName((String)"KNOWS");
        mattiasNode.createRelationshipTo(chrisNode, (RelationshipType)knows);
        long mattiasNodeId = mattiasNode.getId();
        batchDb.shutdown();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fileSystem).newImpermanentDatabase("target/batchdb-example");
        try (Transaction tx = db.beginTx();){
            Node mNode = db.getNodeById(mattiasNodeId);
            Node cNode = mNode.getSingleRelationship((RelationshipType)knows, Direction.OUTGOING).getEndNode();
            Assert.assertThat((Object)cNode, Neo4jMatchers.inTx(db, Neo4jMatchers.hasProperty("name").withValue("Chris")));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void batchDbWithConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("neostore.nodestore.db.mapped_memory", "90M");
        GraphDatabaseService batchDb = BatchInserters.batchDatabase((String)"target/batchdb-example-config", (FileSystemAbstraction)this.fileSystem, config);
        batchDb.shutdown();
    }

    @Before
    public void before() throws Exception {
        this.fileSystem = this.fileSystemRule.get();
        this.fileSystem.mkdirs(new File("target"));
    }
}

