/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.BatchTransaction;
import org.neo4j.test.TargetDirectory;

@Ignore(value="Not a test. Here for show-off purposes")
public class CreateAndLoadDenseNodeIT {
    private final File storeDir = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
    private GraphDatabaseService db;

    @Test
    public void loadSpecificTypeDirectionRelationshipsFast() throws Exception {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.getNodeById(0L);
            tx.success();
        }
        System.out.println("Starting");
        this.loadRelationships(node, MyRelTypes.TEST, Direction.INCOMING);
        this.loadRelationships(node, MyRelTypes.TEST2, Direction.OUTGOING);
        this.loadRelationships(node, MyRelTypes.TEST_TRAVERSAL, Direction.INCOMING);
        System.out.println("Done");
    }

    private int loadRelationships(Node node, RelationshipType type, Direction direction) {
        int count;
        long t = System.currentTimeMillis();
        try (Transaction tx = this.db.beginTx();){
            count = IteratorUtil.count((Iterable)node.getRelationships(type, direction));
            System.out.println("loading " + type + " " + direction + " took " + (System.currentTimeMillis() - t) + "ms");
            t = System.currentTimeMillis();
            int pCount = node.getDegree(type, direction);
            System.out.println("counting " + type + " " + direction + " took " + (System.currentTimeMillis() - t) + "ms");
            Assert.assertEquals((long)count, (long)pCount);
            tx.success();
        }
        return count;
    }

    @Before
    public void before() {
        this.createDbIfNecessary();
        this.db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir.getPath()).setConfig(GraphDatabaseSettings.cache_type, "none").setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").newGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDbIfNecessary() {
        if (!new File(this.storeDir, "neostore").exists()) {
            System.out.println("Creating db");
            this.db = new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.getPath());
            BatchTransaction tx = BatchTransaction.beginBatchTx(this.db);
            try {
                Node node = this.db.createNode();
                this.createRelationships(tx, node, MyRelTypes.TEST, Direction.INCOMING, 1);
                this.createRelationships(tx, node, MyRelTypes.TEST, Direction.OUTGOING, 3000000);
                this.createRelationships(tx, node, MyRelTypes.TEST2, Direction.OUTGOING, 5);
                this.createRelationships(tx, node, MyRelTypes.TEST2, Direction.BOTH, 5);
                this.createRelationships(tx, node, MyRelTypes.TEST_TRAVERSAL, Direction.OUTGOING, 2000000);
                this.createRelationships(tx, node, MyRelTypes.TEST_TRAVERSAL, Direction.INCOMING, 2);
            }
            finally {
                tx.close();
                this.db.shutdown();
            }
        }
    }

    private void createRelationships(BatchTransaction tx, Node node, RelationshipType type, Direction direction, int count) {
        for (int i = 0; i < count; ++i) {
            Node firstNode = direction == Direction.OUTGOING || direction == Direction.BOTH ? node : this.db.createNode();
            Node otherNode = direction == Direction.INCOMING || direction == Direction.BOTH ? node : this.db.createNode();
            firstNode.createRelationshipTo(otherNode, type);
            tx.increment();
        }
    }

    @After
    public void after() {
        this.db.shutdown();
    }
}

