/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.neo4j.adversaries.Adversary;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;

public class AdversarialFileChannel
extends StoreFileChannel {
    private final Adversary adversary;

    public AdversarialFileChannel(StoreFileChannel channel, Adversary adversary) {
        super(channel);
        this.adversary = adversary;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.write(srcs);
    }

    public int write(ByteBuffer src, long position) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.write(src, position);
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.adversary.injectFailure(IOException.class);
        super.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.adversary.injectFailure(IOException.class);
        super.writeAll(src);
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.map(mode, position, size);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.write(srcs, offset, length);
    }

    public StoreFileChannel truncate(long size) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.truncate(size);
    }

    public StoreFileChannel position(long newPosition) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.position(newPosition);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(dst);
            int read = super.read(dst, position);
            dst.limit(oldLimit);
            return read;
        }
        return super.read(dst, position);
    }

    private int mischiefLimit(ByteBuffer buf) {
        int oldLimit = buf.limit();
        int newLimit = oldLimit - Math.max(buf.remaining() / 2, 1);
        buf.limit(newLimit);
        return oldLimit;
    }

    public void force(boolean metaData) throws IOException {
        this.adversary.injectFailure(IOException.class);
        super.force(metaData);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(dst);
            int read = super.read(dst);
            dst.limit(oldLimit);
            return read;
        }
        return super.read(dst);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = this.mischiefLimit(lastBuf);
            long read = super.read(dsts, offset, length);
            lastBuf.limit(oldLimit);
            return read;
        }
        return super.read(dsts, offset, length);
    }

    public long position() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.position();
    }

    public FileLock tryLock() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.tryLock();
    }

    public boolean isOpen() {
        this.adversary.injectFailure(new Class[0]);
        return super.isOpen();
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = this.mischiefLimit(lastBuf);
            long read = super.read(dsts);
            lastBuf.limit(oldLimit);
            return read;
        }
        return super.read(dsts);
    }

    public int write(ByteBuffer src) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.write(src);
    }

    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        super.close();
    }

    public long size() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return super.size();
    }
}

