/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class FirstStartupIT {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldBeEmptyWhenFirstStarted() throws Exception {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.testDir.absolutePath());
        try (Transaction ignore = db.beginTx();){
            GlobalGraphOperations global = GlobalGraphOperations.at((GraphDatabaseService)db);
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)global.getAllNodes()));
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)global.getAllRelationships()));
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)global.getAllRelationshipTypes()));
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)global.getAllLabels()));
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)global.getAllPropertyKeys()));
        }
        db.shutdown();
    }
}

