/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="JH: Working on this, part of the 1.9 merge for tuesday 12th")
public class GraphDatabaseServiceTest {
    @Test
    public void givenShutdownDatabaseWhenBeginTxThenExceptionIsThrown() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        db.shutdown();
        try {
            Transaction tx = db.beginTx();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getClass().getName(), (Matcher)CoreMatchers.equalTo((Object)TransactionFailureException.class.getName()));
        }
    }

    @Test
    public void givenDatabaseAndStartedTxWhenShutdownThenWaitForTxToFinish() throws Exception {
        final GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        final CountDownLatch started = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = db.beginTx();){
                    started.countDown();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    db.createNode();
                    tx.success();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        started.await();
        db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenDatabaseAndStartedTxWhenShutdownAndStartNewTxThenBeginTxTimesOut() throws Exception {
        final GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        final CountDownLatch shutdown = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = db.beginTx();){
                    shutdown.countDown();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    db.createNode();
                    tx.success();
                    Executors.newSingleThreadExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                db.beginTx();
                                result.set(Boolean.TRUE);
                            }
                            catch (Exception e) {
                                result.set(e);
                            }
                            AtomicReference atomicReference = result;
                            synchronized (atomicReference) {
                                result.notifyAll();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        shutdown.await();
        db.shutdown();
        while (result.get() == null) {
            AtomicReference atomicReference = result;
            synchronized (atomicReference) {
                result.wait(100L);
            }
        }
        Assert.assertThat(result.get().getClass(), (Matcher)CoreMatchers.equalTo(TransactionFailureException.class));
    }
}

