/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.tooling.GlobalGraphOperations;

public class LabelScanStoreIT {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldGetNodesWithCreatedLabel() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.Second);
        Node node3 = this.createLabeledNode(Labels.Third);
        Node node4 = this.createLabeledNode(Labels.First, Labels.Second, Labels.Third);
        Node node5 = this.createLabeledNode(Labels.First, Labels.Third);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node4, node5}), (Object)IteratorUtil.asSet(this.getAllNodesWithLabel(Labels.First)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node2, node4}), (Object)IteratorUtil.asSet(this.getAllNodesWithLabel(Labels.Second)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node3, node4, node5}), (Object)IteratorUtil.asSet(this.getAllNodesWithLabel(Labels.Third)));
    }

    @Test
    public void shouldGetNodesWithAddedLabel() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.Second);
        Node node3 = this.createLabeledNode(Labels.Third);
        Node node4 = this.createLabeledNode(Labels.First);
        Node node5 = this.createLabeledNode(Labels.First);
        this.addLabels(node4, Labels.Second, Labels.Third);
        this.addLabels(node5, Labels.Third);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node4, node5}), (Object)IteratorUtil.asSet(this.getAllNodesWithLabel(Labels.First)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node2, node4}), (Object)IteratorUtil.asSet(this.getAllNodesWithLabel(Labels.Second)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node3, node4, node5}), (Object)IteratorUtil.asSet(this.getAllNodesWithLabel(Labels.Third)));
    }

    @Test
    public void shouldGetNodesAfterDeletedNodes() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First, Labels.Second);
        Node node2 = this.createLabeledNode(Labels.First, Labels.Third);
        this.deleteNode(node1);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(Labels.First));
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Node.class), this.getAllNodesWithLabel(Labels.Second));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(Labels.Third));
    }

    @Test
    public void shouldGetNodesAfterRemovedLabels() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First, Labels.Second);
        Node node2 = this.createLabeledNode(Labels.First, Labels.Third);
        this.removeLabels(node1, Labels.First);
        this.removeLabels(node2, Labels.Third);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(Labels.First));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1}), this.getAllNodesWithLabel(Labels.Second));
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Node.class), this.getAllNodesWithLabel(Labels.Third));
    }

    @Test
    public void shouldHandleLargeAmountsOfNodesAddedAndRemovedInSameTx() throws Exception {
        Node node;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        int labelsToAdd = 80;
        int labelsToRemove = 40;
        try (Transaction tx = db.beginTx();){
            int l;
            node = db.createNode();
            for (l = 0; l < labelsToAdd; ++l) {
                node.addLabel(DynamicLabel.label((String)("Label-" + l)));
            }
            for (l = 0; l < labelsToRemove; ++l) {
                node.removeLabel(DynamicLabel.label((String)("Label-" + l)));
            }
            tx.success();
        }
        var6_5 = null;
        try (Transaction ignore = db.beginTx();){
            for (int l = labelsToAdd - 1; l >= labelsToRemove; --l) {
                Label label = DynamicLabel.label((String)("Label-" + l));
                Assert.assertThat((String)("Should have founnd node when looking for label " + label), (Object)Iterables.single((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodesWithLabel(label)), (Matcher)CoreMatchers.equalTo((Object)node));
            }
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }

    private void removeLabels(Node node, Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseService().beginTx();){
            for (Label label : labels) {
                node.removeLabel(label);
            }
            tx.success();
        }
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.dbRule.getGraphDatabaseService().beginTx();){
            node.delete();
            tx.success();
        }
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction tx = this.dbRule.getGraphDatabaseService().beginTx();){
            Set set = IteratorUtil.asSet((Iterable)GlobalGraphOperations.at((GraphDatabaseService)this.dbRule.getGraphDatabaseService()).getAllNodesWithLabel(label));
            return set;
        }
    }

    private Node createLabeledNode(Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseService().beginTx();){
            Node node = this.dbRule.getGraphDatabaseService().createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private void addLabels(Node node, Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseService().beginTx();){
            for (Label label : labels) {
                node.addLabel(label);
            }
            tx.success();
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

