/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import javax.transaction.SystemException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.mockfs.LimitedFileSystemGraphDatabase;

public class RunOutOfDiskSpaceIT {
    @Test
    public void shouldPropagateIOExceptions() throws Exception {
        TransactionFailureException exceptionThrown = null;
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase();
        db.runOutOfDiskSpaceNao();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        try {
            tx.finish();
            Assert.fail((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.");
        }
        catch (TransactionFailureException e) {
            exceptionThrown = e;
        }
        Assert.assertThat((Object)exceptionThrown.getCause(), (Matcher)CoreMatchers.isA(Throwable.class));
        Assert.assertThat((Object)exceptionThrown.getCause().getCause(), (Matcher)CoreMatchers.isA(Throwable.class));
        Assert.assertThat((Object)exceptionThrown.getCause().getCause().getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IOException.class)));
    }

    @Test
    public void shouldStopDatabaseWhenOutOfDiskSpace() throws Exception {
        TransactionFailureException errorCaught = null;
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase();
        db.runOutOfDiskSpaceNao();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        try {
            tx.finish();
            Assert.fail((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
        try {
            db.beginTx();
            Assert.fail((String)"Expected tx begin to throw TransactionFailureException when tx manager breaks.");
        }
        catch (TransactionFailureException e) {
            errorCaught = e;
        }
        Assert.assertThat((Object)errorCaught.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SystemException.class)));
    }
}

