/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.cache.SoftCacheProvider;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.test.TestGraphDatabaseFactory;

public class SetCacheProvidersTest {
    @Test
    public void testSetNoCache() {
        ArrayList cacheList = new ArrayList();
        TestGraphDatabaseFactory gdbf = new TestGraphDatabaseFactory();
        gdbf.setCacheProviders(cacheList);
        try {
            gdbf.newImpermanentDatabase();
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("No provider for cache type"));
            Assert.assertTrue((boolean)iae.getMessage().contains("register"));
            Assert.assertTrue((boolean)iae.getMessage().contains("missing"));
        }
    }

    @Test
    public void testSetSoftRefCache() {
        ArrayList<SoftCacheProvider> cacheList = new ArrayList<SoftCacheProvider>();
        TestGraphDatabaseFactory gdbf = new TestGraphDatabaseFactory();
        cacheList.add(new SoftCacheProvider());
        gdbf.setCacheProviders(cacheList);
        GraphDatabaseAPI db = (GraphDatabaseAPI)gdbf.newImpermanentDatabase();
        Assert.assertEquals((Object)"soft", (Object)((NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class)).getCacheType().getName());
    }
}

