/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.neo4j.graphdb.mockfs.BreakableFileChannel;
import org.neo4j.graphdb.mockfs.FileSystemGuard;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;

public class BreakableFileSystemAbstraction
implements FileSystemAbstraction,
FileSystemGuard {
    private final FileSystemGuard guard;
    private final FileSystemAbstraction inner;

    @Override
    public void checkOperation(FileSystemGuard.OperationType operationType, File onFile, int bytesWrittenTotal, int bytesWrittenThisCall, long channelPosition) throws IOException {
        this.guard.checkOperation(operationType, onFile, bytesWrittenTotal, bytesWrittenThisCall, channelPosition);
    }

    public BreakableFileSystemAbstraction(FileSystemAbstraction inner, FileSystemGuard guard) {
        this.inner = inner;
        this.guard = guard;
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        return new BreakableFileChannel(this.inner.open(fileName, mode), fileName, this);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, "rw"), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, "r"));
    }

    public Reader openAsReader(File fileName, String encoding) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), encoding);
    }

    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append));
    }

    public FileLock tryLock(File fileName, StoreChannel channel) throws IOException {
        return this.inner.tryLock(fileName, channel);
    }

    public StoreChannel create(File fileName) throws IOException {
        return new BreakableFileChannel(this.inner.create(fileName), fileName, this);
    }

    public boolean fileExists(File fileName) {
        return this.inner.fileExists(fileName);
    }

    public long getFileSize(File fileName) {
        return this.inner.getFileSize(fileName);
    }

    public boolean deleteFile(File fileName) {
        return this.inner.deleteFile(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.inner.deleteRecursively(directory);
    }

    public boolean mkdir(File fileName) {
        return this.inner.mkdir(fileName);
    }

    public void mkdirs(File fileName) throws IOException {
        this.inner.mkdirs(fileName);
    }

    public boolean renameFile(File from, File to) throws IOException {
        return this.inner.renameFile(from, to);
    }

    public File[] listFiles(File directory) {
        return this.inner.listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.inner.listFiles(directory, filter);
    }

    public boolean isDirectory(File file) {
        return this.inner.isDirectory(file);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.inner.moveToDirectory(file, toDirectory);
    }

    public void copyFile(File from, File to) throws IOException {
        this.inner.copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.inner.copyRecursively(fromDirectory, toDirectory);
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return (K)this.inner.getOrCreateThirdPartyFileSystem(clazz, creator);
    }
}

