/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.neo4j.graphdb.mockfs.LimitedFilesystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

public class LimitedFileChannel
implements StoreChannel {
    private final StoreChannel inner;
    private LimitedFilesystemAbstraction fs;

    public LimitedFileChannel(StoreChannel inner, LimitedFilesystemAbstraction limitedFilesystemAbstraction) {
        this.inner = inner;
        this.fs = limitedFilesystemAbstraction;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.inner.read(byteBuffer);
    }

    public long read(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        return this.inner.read(byteBuffers, i, i1);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return 0L;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffers, i, i1);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return 0L;
    }

    public long position() throws IOException {
        return this.inner.position();
    }

    public LimitedFileChannel position(long l) throws IOException {
        return new LimitedFileChannel(this.inner.position(l), this.fs);
    }

    public long size() throws IOException {
        return this.inner.size();
    }

    public LimitedFileChannel truncate(long l) throws IOException {
        return new LimitedFileChannel(this.inner.truncate(l), this.fs);
    }

    public void force(boolean b) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.force(b);
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.read(byteBuffer, l);
    }

    public FileLock tryLock() throws IOException {
        return this.inner.tryLock();
    }

    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.write(byteBuffer, l);
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.writeAll(src);
    }

    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l1) throws IOException {
        return this.inner.map(mapMode, l, l1);
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }

    public void close() throws IOException {
        this.inner.close();
    }
}

