/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.HostnamePort;

public class HostnamePortTest {
    @Test
    public void testHostnameOnly() {
        HostnamePort hostnamePort = new HostnamePort("myhost");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    public void testHostnamePort() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1234");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1234}));
    }

    @Test
    public void testHostnamePortRange() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1234-1243");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1243}));
    }

    @Test
    public void testHostnamePortRangeInversed() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1243-1234");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1243));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1243, 1234}));
    }

    @Test
    public void testSinglePortOnly() throws Exception {
        HostnamePort hostnamePort = new HostnamePort(":1234");
        Assert.assertNull((Object)hostnamePort.getHost());
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1234}));
    }

    @Test
    public void testPortRangeOnly() throws Exception {
        HostnamePort hostnamePort = new HostnamePort(":1230-1240");
        Assert.assertNull((Object)hostnamePort.getHost());
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1230));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1230, 1240}));
    }

    @Test
    public void testDefaultHost() throws Exception {
        HostnamePort hostnamePort = new HostnamePort(":1234");
        Assert.assertThat((Object)hostnamePort.getHost("1.2.3.4"), (Matcher)CoreMatchers.equalTo((Object)"1.2.3.4"));
    }

    @Test
    public void testMatches() throws Exception {
        HostnamePort hostnamePortSinglePort = new HostnamePort("host1:1234");
        Assert.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://host1:1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://host1:1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://host2:1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://host2:1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://host1")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://host2")));
        HostnamePort hostnamePortWithRange = new HostnamePort("host1:1234-1236");
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://host1:1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://host1:1235")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://host1:1236")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://host2:1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://host2:1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://host1:1233")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://host1:1237")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://host1")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://host2")));
    }

    @Test
    public void testMatchesNullHost() throws Exception {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://host1:1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("host1:1234")));
    }

    @Test
    public void testHostnameLookup() throws Exception {
        String hostName = InetAddress.getLocalHost().getHostName();
        HostnamePort hostnamePort = new HostnamePort(hostName, 1234);
        Assert.assertThat((Object)hostnamePort.toString(null), (Matcher)CoreMatchers.equalTo((Object)(InetAddress.getByName(hostName).getHostAddress() + ":1234")));
    }

    @Test
    public void testIPv6Address() {
        HostnamePort hostnamePort = new HostnamePort("[2001:cdba:0:0:0:0:3257:9652]");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)HostnamePortTest.resolveHost("[2001:cdba:0:0:0:0:3257:9652]")));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    public void testIPv6AddressWithSchemeAndPort() {
        HostnamePort hostnamePort = new HostnamePort("foo://[ff02::1:1]:9191");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)HostnamePortTest.resolveHost("[ff02::1:1]")));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)9191));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{9191, 9191}));
    }

    @Test
    public void testIPv6Localhost() {
        HostnamePort hostnamePort = new HostnamePort("[::1]");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)HostnamePortTest.resolveHost("[::1]")));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    public void testIPv6LocalhostWithSchemeAndPort() {
        HostnamePort hostnamePort = new HostnamePort("foo://[::1]:6362");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)HostnamePortTest.resolveHost("[::1]")));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)6362));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{6362, 6362}));
    }

    private static String resolveHost(String address) {
        try {
            return InetAddress.getByName(address).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to resolve host for '" + address + "'", e);
        }
    }
}

