/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.MapUtil;

public class SettingsTest {
    @Test
    public void testInteger() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testList() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4");
        Assert.assertThat((Object)((List)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        Setting setting2 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4,");
        Assert.assertThat((Object)((List)setting2.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        Setting setting3 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"");
        Assert.assertThat((Object)((List)setting3.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
    }

    @Test
    public void testMin() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3", (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(2))});
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "1"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testMax() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3", (Function2[])new Function2[]{Settings.max((Comparable)Integer.valueOf(5))});
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "7"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testRange() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3", (Function2[])new Function2[]{Settings.range((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))});
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "1"})));
            Assert.fail();
        }
        catch (InvalidSettingException e) {
            // empty catch block
        }
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "6"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testMatches() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.STRING, (String)"abc", (Function2[])new Function2[]{Settings.matches((String)"a*b*c*")});
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "aaabbbccc"}))), (Matcher)CoreMatchers.equalTo((Object)"aaabbbccc"));
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "cba"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test(expected=InvalidSettingException.class)
    public void testDurationWithBrokenDefault() {
        Setting setting = Settings.setting((String)"foo.bar", (Function)Settings.DURATION, (String)"1s", (Function2[])new Function2[]{Settings.min((Comparable)((Comparable)Settings.DURATION.apply((Object)"3s")))});
        setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])));
    }

    @Test(expected=InvalidSettingException.class)
    public void testDurationWithValueNotWithinConstraint() {
        Setting setting = Settings.setting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s", (Function2[])new Function2[]{Settings.min((Comparable)((Comparable)Settings.DURATION.apply((Object)"3s")))});
        setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo.bar", "2s"})));
    }

    @Test
    public void testDuration() {
        Setting setting = Settings.setting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s", (Function2[])new Function2[]{Settings.min((Comparable)((Comparable)Settings.DURATION.apply((Object)"3s")))});
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo.bar", "4s"}))), (Matcher)CoreMatchers.equalTo((Object)4000L));
    }

    @Test
    public void testDefault() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testMandatory() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)Settings.MANDATORY);
        try {
            setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPaths() {
        Setting home = Settings.setting((String)"home", (Function)Settings.PATH, (String)".");
        Setting config = Settings.setting((String)"config", (Function)Settings.PATH, (String)"config.properties", (Function2[])new Function2[]{Settings.basePath((Setting)home), Settings.isFile});
        Assert.assertThat((Object)((File)config.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])))).getAbsolutePath(), (Matcher)CoreMatchers.equalTo((Object)new File(".", "config.properties").getAbsolutePath()));
    }

    @Test
    public void testInheritOneLevel() {
        Setting root = Settings.setting((String)"root", (Function)Settings.INTEGER, (String)"4");
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (Setting)root);
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "1"}))), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testInheritHierarchy() {
        Setting a = Settings.setting((String)"A", (Function)Settings.STRING, (String)"A");
        Setting b = Settings.setting((String)"B", (Function)Settings.STRING, (String)"B", (Setting)a, (Function2[])new Function2[0]);
        Setting c = Settings.setting((String)"C", (Function)Settings.STRING, (String)"C", (Setting)b, (Function2[])new Function2[0]);
        Setting d = Settings.setting((String)"D", (Function)Settings.STRING, (Setting)b);
        Setting e = Settings.setting((String)"E", (Function)Settings.STRING, (Setting)d);
        Assert.assertThat((Object)c.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"C", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"A", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"A", "Y", "B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)d.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
        Assert.assertThat((Object)e.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMandatoryApplyToInherited() {
        Setting x = Settings.setting((String)"X", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
        Setting y = Settings.setting((String)"Y", (Function)Settings.STRING, (String)Settings.MANDATORY, (Setting)x, (Function2[])new Function2[0]);
        y.apply((Object)Functions.nullFunction());
    }

    @Test
    public void testLogicalLogRotationThreshold() throws Exception {
        Setting setting = GraphDatabaseSettings.logical_log_rotation_threshold;
        long defaultValue = (Long)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[0])));
        long kiloValue = (Long)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{setting.name(), "10k"})));
        long megaValue = (Long)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{setting.name(), "10M"})));
        long gigaValue = (Long)setting.apply((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{setting.name(), "10g"})));
        Assert.assertThat((Object)defaultValue, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((long)10240L, (long)kiloValue);
        Assert.assertEquals((long)0xA00000L, (long)megaValue);
        Assert.assertEquals((long)0x280000000L, (long)gigaValue);
    }
}

