/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Args;

public class TestArgs {
    @Test
    public void testInterleavedParametersWithValuesAndNot() {
        String[] line = new String[]{"-host", "machine.foo.com", "-port", "1234", "-v", "-name", "othershell"};
        Args args = new Args(line);
        Assert.assertEquals((Object)"machine.foo.com", (Object)args.get("host", null));
        Assert.assertEquals((Object)"1234", (Object)args.get("port", null));
        Assert.assertEquals((long)1234L, (long)args.getNumber("port", null).intValue());
        Assert.assertEquals((Object)"othershell", (Object)args.get("name", null));
        Assert.assertTrue((boolean)args.has("v"));
        Assert.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    public void testInterleavedEqualsArgsAndSplitKeyValue() {
        String[] line = new String[]{"-host=localhost", "-v", "--port", "1234", "param1", "-name=Something", "param2"};
        Args args = new Args(line);
        Assert.assertEquals((Object)"localhost", (Object)args.get("host", null));
        Assert.assertTrue((boolean)args.has("v"));
        Assert.assertEquals((long)1234L, (long)args.getNumber("port", null).intValue());
        Assert.assertEquals((Object)"Something", (Object)args.get("name", null));
        Assert.assertEquals((long)2L, (long)args.orphans().size());
        Assert.assertEquals((Object)"param1", args.orphans().get(0));
        Assert.assertEquals((Object)"param2", args.orphans().get(1));
    }

    @Test
    public void testParameterWithDashValue() {
        String[] line = new String[]{"-file", "-"};
        Args args = new Args(line);
        Assert.assertEquals((long)1L, (long)args.asMap().size());
        Assert.assertEquals((Object)"-", (Object)args.get("file", null));
        Assert.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    public void testEnum() {
        String[] line = new String[]{"--enum=" + MyEnum.second.name()};
        Args args = new Args(line);
        Enum result = args.getEnum(MyEnum.class, "enum", (Enum)MyEnum.first);
        Assert.assertEquals((Object)((Object)MyEnum.second), (Object)result);
    }

    @Test
    public void testEnumWithDefault() {
        String[] line = new String[]{};
        Args args = new Args(line);
        MyEnum result = (MyEnum)args.getEnum(MyEnum.class, "enum", (Enum)MyEnum.third);
        Assert.assertEquals((Object)((Object)MyEnum.third), (Object)((Object)result));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumWithInvalidValue() throws Exception {
        String[] line = new String[]{"--myenum=something"};
        Args args = new Args(line);
        args.getEnum(MyEnum.class, "myenum", (Enum)MyEnum.third);
    }

    private static enum MyEnum {
        first,
        second,
        third;

    }
}

