/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.Clock;

public class TickingClock
implements Clock {
    private long current;
    private long tick;
    private Map<Long, List<Runnable>> actions = new HashMap<Long, List<Runnable>>();

    public TickingClock(long current, long tick) {
        this.current = current;
        this.tick = tick;
    }

    public TickingClock at(long time, Runnable action) {
        List<Runnable> actionList = this.actions.get(time);
        if (actionList == null) {
            actionList = new ArrayList<Runnable>();
            this.actions.put(time, actionList);
        }
        actionList.add(action);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long currentTimeMillis() {
        List<Runnable> actionList = this.actions.get(this.current);
        if (actionList != null) {
            for (Runnable runnable : actionList) {
                runnable.run();
            }
        }
        try {
            long l = this.current;
            return l;
        }
        finally {
            this.current += this.tick;
        }
    }
}

