/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.test.TargetDirectory;

public class AutoConfiguratorTest {
    private static final long MiB = 0x100000L;
    private static final long GiB = 0x40000000L;
    @Rule
    public final TestName testName = new TestName();
    private File storeDir;

    @Before
    public void given() {
        this.storeDir = TargetDirectory.forTest(this.getClass()).cleanDirectory(this.testName.getMethodName());
    }

    @Test
    public void shouldNotConfigureMemoryMappingWhenUnableToAccessPhysicalMemorySize() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        ConsoleLogger logger = (ConsoleLogger)Mockito.mock(ConsoleLogger.class);
        this.mockFileSize(fs, "nodestore.db", 0x3200000000L);
        this.mockFileSize(fs, "relationshipstore.db", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db.strings", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db.arrays", 0x3200000000L);
        long vmMemory = 0x20000000L;
        long physicalMemory = -1L;
        AutoConfigurator autoConf = new AutoConfigurator(fs, this.storeDir, true, physicalMemory, vmMemory, logger);
        ((ConsoleLogger)Mockito.verify((Object)logger)).warn("Could not determine the size of the physical memory. Continuing but without memory mapped buffers.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{logger});
        Assert.assertEquals(Collections.emptyMap(), (Object)autoConf.configure());
    }

    @Test
    public void shouldProvideDefaultAssignmentsForHugeFiles() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.mockFileSize(fs, "nodestore.db", 0x3200000000L);
        this.mockFileSize(fs, "relationshipstore.db", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db.strings", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db.arrays", 0x3200000000L);
        long availableMem = 100000L;
        long physicalMemory = 2L * availableMem;
        long vmMemory = (long)Math.ceil((double)physicalMemory - (double)availableMem / 0.85);
        AutoConfigurator autoConf = new AutoConfigurator(fs, this.storeDir, true, physicalMemory * 0x100000L, vmMemory * 0x100000L, (ConsoleLogger)Mockito.mock(ConsoleLogger.class));
        Map configuration = autoConf.configure();
        this.assertMappedMemory(configuration, "75000M", "relationshipstore.db");
        this.assertMappedMemory(configuration, " 5000M", "nodestore.db");
        this.assertMappedMemory(configuration, "15000M", "propertystore.db");
        this.assertMappedMemory(configuration, " 3750M", "propertystore.db.strings");
        this.assertMappedMemory(configuration, " 1250M", "propertystore.db.arrays");
    }

    @Test
    public void shouldProvideDefaultAssignmentsForHugeFilesWhenMemoryMappingIsNotUsed() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.mockFileSize(fs, "nodestore.db", 0x3200000000L);
        this.mockFileSize(fs, "relationshipstore.db", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db.strings", 0x3200000000L);
        this.mockFileSize(fs, "propertystore.db.arrays", 0x3200000000L);
        long availableMem = 100000L;
        AutoConfigurator autoConf = new AutoConfigurator(fs, this.storeDir, false, 10737418240000L, 2L * availableMem * 0x100000L, (ConsoleLogger)Mockito.mock(ConsoleLogger.class));
        Map configuration = autoConf.configure();
        this.assertMappedMemory(configuration, "75000M", "relationshipstore.db");
        this.assertMappedMemory(configuration, " 5000M", "nodestore.db");
        this.assertMappedMemory(configuration, "15000M", "propertystore.db");
        this.assertMappedMemory(configuration, " 3750M", "propertystore.db.strings");
        this.assertMappedMemory(configuration, " 1250M", "propertystore.db.arrays");
    }

    @Test
    public void shouldProvideDefaultAssignmentsForEmptyFiles() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.mockFileSize(fs, "nodestore.db", 0L);
        this.mockFileSize(fs, "relationshipstore.db", 0L);
        this.mockFileSize(fs, "propertystore.db", 0L);
        this.mockFileSize(fs, "propertystore.db.strings", 0L);
        this.mockFileSize(fs, "propertystore.db.arrays", 0L);
        long availableMem = 100000L;
        long physicalMemory = 2L * availableMem;
        long vmMemory = (long)Math.ceil((double)physicalMemory - (double)availableMem / 0.85);
        AutoConfigurator autoConf = new AutoConfigurator(fs, this.storeDir, true, physicalMemory * 0x100000L, vmMemory * 0x100000L, (ConsoleLogger)Mockito.mock(ConsoleLogger.class));
        Map configuration = autoConf.configure();
        this.assertMappedMemory(configuration, "15000M", "relationshipstore.db");
        this.assertMappedMemory(configuration, " 3400M", "nodestore.db");
        this.assertMappedMemory(configuration, "12240M", "propertystore.db");
        this.assertMappedMemory(configuration, "10404M", "propertystore.db.strings");
        this.assertMappedMemory(configuration, "11791M", "propertystore.db.arrays");
    }

    @Test
    public void shouldProvideDefaultAssignmentsForEmptyFilesWhenMemoryMappingIsNotUsed() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.mockFileSize(fs, "nodestore.db", 0L);
        this.mockFileSize(fs, "relationshipstore.db", 0L);
        this.mockFileSize(fs, "propertystore.db", 0L);
        this.mockFileSize(fs, "propertystore.db.strings", 0L);
        this.mockFileSize(fs, "propertystore.db.arrays", 0L);
        long availableMem = 100000L;
        AutoConfigurator autoConf = new AutoConfigurator(fs, this.storeDir, false, 10737418240000L, 2L * availableMem * 0x100000L, (ConsoleLogger)Mockito.mock(ConsoleLogger.class));
        Map configuration = autoConf.configure();
        this.assertMappedMemory(configuration, "15000M", "relationshipstore.db");
        this.assertMappedMemory(configuration, " 3400M", "nodestore.db");
        this.assertMappedMemory(configuration, "12240M", "propertystore.db");
        this.assertMappedMemory(configuration, "10404M", "propertystore.db.strings");
        this.assertMappedMemory(configuration, "11791M", "propertystore.db.arrays");
    }

    @Test
    public void shouldProvideZeroMappedMemoryWhenPhysicalLessThanJVMMemory() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.mockFileSize(fs, "nodestore.db", 0L);
        this.mockFileSize(fs, "relationshipstore.db", 0L);
        this.mockFileSize(fs, "propertystore.db", 0L);
        this.mockFileSize(fs, "propertystore.db.strings", 0L);
        this.mockFileSize(fs, "propertystore.db.arrays", 0L);
        ConsoleLogger mock = (ConsoleLogger)Mockito.mock(ConsoleLogger.class);
        AutoConfigurator autoConf = new AutoConfigurator(fs, this.storeDir, true, 0x8000000L, 0x10000000L, mock);
        Map configuration = autoConf.configure();
        ((ConsoleLogger)Mockito.verify((Object)mock)).log(Matchers.startsWith((String)"WARNING!"));
        this.assertMappedMemory(configuration, "0M", "relationshipstore.db");
        this.assertMappedMemory(configuration, "0M", "nodestore.db");
        this.assertMappedMemory(configuration, "0M", "propertystore.db");
        this.assertMappedMemory(configuration, "0M", "propertystore.db.strings");
        this.assertMappedMemory(configuration, "0M", "propertystore.db.arrays");
    }

    private void assertMappedMemory(Map<String, String> configuration, String expected, String store) {
        Assert.assertEquals((String)store, (Object)expected.trim(), (Object)configuration.get("neostore." + store + ".mapped_memory"));
    }

    private void mockFileSize(FileSystemAbstraction fs, String file, long size) {
        Mockito.when((Object)fs.getFileSize(new File(this.storeDir, "neostore." + file))).thenReturn((Object)size);
    }
}

