/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;

public class DefaultFileSystemAbstractionTest {
    private final DefaultFileSystemAbstraction defaultFileSystemAbstraction = new DefaultFileSystemAbstraction();
    private File path;

    @Before
    public void before() throws Exception {
        this.path = new File("target/" + UUID.randomUUID());
    }

    @Test
    public void shouldCreatePath() throws Exception {
        this.defaultFileSystemAbstraction.mkdirs(this.path);
        Assert.assertThat((Object)this.path.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateDeepPath() throws Exception {
        this.path = new File(this.path, UUID.randomUUID() + "/" + UUID.randomUUID());
        this.defaultFileSystemAbstraction.mkdirs(this.path);
        Assert.assertThat((Object)this.path.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreatePathThatAlreadyExists() throws Exception {
        Assert.assertTrue((boolean)this.path.mkdir());
        this.defaultFileSystemAbstraction.mkdirs(this.path);
        Assert.assertThat((Object)this.path.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreatePathThatPointsToFile() throws Exception {
        Assert.assertTrue((boolean)this.path.mkdir());
        this.path = new File(this.path, "some_file");
        Assert.assertTrue((boolean)this.path.createNewFile());
        this.defaultFileSystemAbstraction.mkdirs(this.path);
        Assert.assertThat((Object)this.path.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldFailGracefullyWhenPathCannotBeCreated() throws Exception {
        this.path = new File("target/" + UUID.randomUUID()){

            @Override
            public boolean mkdirs() {
                return false;
            }
        };
        try {
            this.defaultFileSystemAbstraction.mkdirs(this.path);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertThat((Object)this.path.exists(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)String.format("Unable to create directory path [%s] for Neo4j store.", this.path)));
        }
    }
}

