/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultGraphDatabaseDependencies;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.BufferingLogging;

public class DefaultGraphDatabaseDependenciesTest {
    @Test
    public void graphDatabaseSettingsIsTheDefaultSettingsClass() {
        DefaultGraphDatabaseDependencies deps = new DefaultGraphDatabaseDependencies();
        Class[] settingsClasses = new Class[]{GraphDatabaseSettings.class};
        this.verifySettingsClasses((GraphDatabaseDependencies)deps, settingsClasses);
    }

    @Test
    public void canSpecifyLogger() {
        BufferingLogging logging = new BufferingLogging();
        DefaultGraphDatabaseDependencies deps = new DefaultGraphDatabaseDependencies((Logging)logging);
        Assert.assertThat((Object)deps.logging(), (Matcher)Matchers.sameInstance((Object)((Object)logging)));
    }

    @Test
    public void canSpecifySettingsClasses() {
        DefaultGraphDatabaseDependencies deps = new DefaultGraphDatabaseDependencies(new Class[]{A.class, B.class});
        this.verifySettingsClasses((GraphDatabaseDependencies)deps, A.class, B.class);
    }

    @Test
    public void canSpecifyLoggerAndSettingsClasses() {
        BufferingLogging logging = new BufferingLogging();
        DefaultGraphDatabaseDependencies deps = new DefaultGraphDatabaseDependencies((Logging)logging, new Class[]{A.class, B.class});
        Assert.assertThat((Object)deps.logging(), (Matcher)Matchers.sameInstance((Object)((Object)logging)));
        this.verifySettingsClasses((GraphDatabaseDependencies)deps, A.class, B.class);
    }

    private void verifySettingsClasses(GraphDatabaseDependencies deps, Class<?> ... settingsClasses) {
        Assert.assertThat((Object)deps.settingsClasses(), (Matcher)Matchers.iterableWithSize((int)settingsClasses.length));
        Assert.assertThat((Object)deps.settingsClasses(), (Matcher)Matchers.containsInAnyOrder((Object[])settingsClasses));
    }

    private static class B {
        private B() {
        }
    }

    private static class A {
        private A() {
        }
    }
}

