/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.ImpermanentGraphDatabase;

public class DiagnosticsLoggingTest {
    @Test
    public void shouldSeeHelloWorld() {
        FakeDatabase db = new FakeDatabase();
        FakeLogger logger = db.getLogger();
        String messages = logger.getMessages();
        Assert.assertThat((Object)messages, (Matcher)JUnitMatchers.containsString((String)"Network information"));
        Assert.assertThat((Object)messages, (Matcher)JUnitMatchers.containsString((String)"Disk space on partition"));
        Assert.assertThat((Object)messages, (Matcher)JUnitMatchers.containsString((String)"Local timezone"));
        db.shutdown();
    }

    private class FakeDatabase
    extends ImpermanentGraphDatabase {
        private FakeDatabase() {
        }

        @Override
        protected Logging createLogging() {
            return new FakeLogger();
        }

        public FakeLogger getLogger() {
            return (FakeLogger)this.logging;
        }
    }

    private class FakeLogger
    extends StringLogger
    implements Logging {
        private final StringBuilder messages = new StringBuilder();

        private FakeLogger() {
        }

        public String getMessages() {
            return this.messages.toString();
        }

        private void appendLine(String mess) {
            this.messages.append(mess).append("\n");
        }

        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
            this.appendLine(msg);
            source.visit((Object)new StringLogger.LineLogger(){

                public void logLine(String line) {
                    FakeLogger.this.appendLine(line);
                }
            });
        }

        public void logMessage(String msg, boolean flush) {
            this.appendLine(msg);
        }

        public void logMessage(String msg, LogMarker marker) {
            this.appendLine(msg);
        }

        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.appendLine(msg);
        }

        public void addRotationListener(Runnable listener) {
        }

        public void flush() {
        }

        public void close() {
        }

        protected void logLine(String line) {
            this.appendLine(line);
        }

        public StringLogger getMessagesLog(Class loggingClass) {
            if (loggingClass.equals(DiagnosticsManager.class)) {
                return this;
            }
            return StringLogger.DEV_NULL;
        }

        public ConsoleLogger getConsoleLog(Class loggingClass) {
            return new ConsoleLogger(StringLogger.SYSTEM);
        }

        public void init() throws Throwable {
        }

        public void start() throws Throwable {
        }

        public void stop() throws Throwable {
        }

        public void shutdown() throws Throwable {
        }
    }
}

