/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;

public class GuardPerformanceImpact {
    private static String dir = TargetDirectory.forTest(GuardPerformanceImpact.class).makeGraphDbDir().getAbsolutePath();
    private static final int RUNS = 10;
    private static final int PER_TX = 10000;
    private static final int TX = 100;

    public static void main(String[] args) throws IOException {
        GuardPerformanceImpact.test(Type.enabled);
    }

    private static void test(Type type) throws IOException {
        switch (type) {
            case without: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.withoutGuard());
                }
                break;
            }
            case enabled: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.guardEnabled());
                }
                break;
            }
            case activeOpscount: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.guardEnabledAndActiveOpsCount());
                }
                break;
            }
            case activeTimeout: {
                for (int i = 0; i < 10; ++i) {
                    System.err.println(GuardPerformanceImpact.guardEnabledAndActiveTimeout());
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long withoutGuard() throws IOException {
        GraphDatabaseAPI db = GuardPerformanceImpact.prepare(false);
        try {
            long start = System.currentTimeMillis();
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    private static GraphDatabaseAPI prepare(boolean insertGuard) throws IOException {
        return (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir).setConfig(MapUtil.stringMap((String[])new String[]{"enable_execution_guard", String.valueOf(insertGuard)})).newGraphDatabase();
    }

    private static void createData(GraphDatabaseAPI db) {
        for (int j = 0; j < 100; ++j) {
            Transaction tx = db.beginTx();
            for (int i = 0; i < 10000; ++i) {
                db.createNode();
            }
            tx.success();
            tx.finish();
        }
    }

    private static void cleanup(GraphDatabaseAPI db) throws IOException {
        db.shutdown();
        FileUtils.deleteRecursively((File)new File(dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long guardEnabled() throws IOException {
        GraphDatabaseAPI db = GuardPerformanceImpact.prepare(true);
        try {
            long start = System.currentTimeMillis();
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long guardEnabledAndActiveOpsCount() throws IOException {
        GraphDatabaseAPI db = GuardPerformanceImpact.prepare(true);
        try {
            long start = System.currentTimeMillis();
            ((Guard)db.getDependencyResolver().resolveDependency(Guard.class)).startOperationsCount(Integer.MAX_VALUE);
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long guardEnabledAndActiveTimeout() throws IOException {
        GraphDatabaseAPI db = GuardPerformanceImpact.prepare(true);
        try {
            long start = System.currentTimeMillis();
            ((Guard)db.getDependencyResolver().resolveDependency(Guard.class)).startTimeout(Integer.MAX_VALUE);
            GuardPerformanceImpact.createData(db);
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            GuardPerformanceImpact.cleanup(db);
        }
    }

    private static enum Type {
        without,
        enabled,
        activeTimeout,
        activeOpscount;

    }
}

