/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.NodeAutoIndexerImpl;

public class NodeAutoIndexerImplTest {
    @Test
    public void shouldNotRemoveFromIndexForNonAutoIndexedProperty() throws Exception {
        String indexedPropertyName = "someProperty";
        String nonIndexedPropertyName = "someOtherProperty";
        IndexManagerImpl indexManager = (IndexManagerImpl)Mockito.mock(IndexManagerImpl.class, (Answer)Mockito.RETURNS_MOCKS);
        NodeAutoIndexerImpl index = new NodeAutoIndexerImpl((Config)Mockito.mock(Config.class), indexManager, (NodeManager)Mockito.mock(NodeManager.class));
        index.startAutoIndexingProperty(indexedPropertyName);
        index.propertyRemoved((PropertyContainer)Mockito.mock(Node.class), nonIndexedPropertyName, new Object());
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexManager});
    }

    @Test
    public void shouldNotAddToIndexForNonAutoIndexedProperty() throws Exception {
        String indexedPropertyName = "someProperty";
        String nonIndexedPropertyName = "someOtherProperty";
        IndexManagerImpl indexManager = (IndexManagerImpl)Mockito.mock(IndexManagerImpl.class, (Answer)Mockito.RETURNS_MOCKS);
        NodeAutoIndexerImpl index = new NodeAutoIndexerImpl((Config)Mockito.mock(Config.class), indexManager, (NodeManager)Mockito.mock(NodeManager.class));
        index.startAutoIndexingProperty(indexedPropertyName);
        index.propertyAdded((PropertyContainer)Mockito.mock(Node.class), nonIndexedPropertyName, new Object());
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexManager});
    }

    @Test
    public void shouldNotAddOrRemoveFromIndexForNonAutoIndexedProperty() throws Exception {
        String indexedPropertyName = "someProperty";
        String nonIndexedPropertyName = "someOtherProperty";
        IndexManagerImpl indexManager = (IndexManagerImpl)Mockito.mock(IndexManagerImpl.class, (Answer)Mockito.RETURNS_MOCKS);
        NodeAutoIndexerImpl index = new NodeAutoIndexerImpl((Config)Mockito.mock(Config.class), indexManager, (NodeManager)Mockito.mock(NodeManager.class));
        index.startAutoIndexingProperty(indexedPropertyName);
        index.propertyChanged((PropertyContainer)Mockito.mock(Node.class), nonIndexedPropertyName, new Object(), new Object());
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexManager});
    }
}

