/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.CannedFileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.TargetDirectory;

public class StoreLockerTest {
    private static final TargetDirectory target = TargetDirectory.forTest(StoreLockerTest.class);

    @Test
    public void shouldObtainLockWhenStoreFileNotLocked() throws Exception {
        CannedFileSystemAbstraction fileSystemAbstraction = new CannedFileSystemAbstraction(true, null, null, true, CannedFileSystemAbstraction.NOTHING);
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        try {
            storeLocker.checkLock(target.cleanDirectory("unused"));
        }
        catch (StoreLockException e) {
            Assert.fail();
        }
    }

    @Test
    public void shouldCreateStoreDirAndObtainLockWhenStoreDirDoesNotExist() throws Exception {
        CannedFileSystemAbstraction fileSystemAbstraction = new CannedFileSystemAbstraction(false, null, null, true, CannedFileSystemAbstraction.NOTHING);
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        try {
            storeLocker.checkLock(target.cleanDirectory("unused"));
        }
        catch (StoreLockException e) {
            Assert.fail();
        }
    }

    @Test
    public void shouldNotObtainLockWhenStoreDirCannotBeCreated() throws Exception {
        CannedFileSystemAbstraction fileSystemAbstraction = new CannedFileSystemAbstraction(false, new IOException("store dir could not be created"), null, true, CannedFileSystemAbstraction.NOTHING);
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        File storeDir = target.cleanDirectory("unused");
        try {
            storeLocker.checkLock(storeDir);
            Assert.fail();
        }
        catch (StoreLockException e) {
            String msg = String.format("Unable to create path for store dir: %s. Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", storeDir);
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)msg));
        }
    }

    @Test
    public void shouldNotObtainLockWhenUnableToOpenLockFile() throws Exception {
        CannedFileSystemAbstraction fileSystemAbstraction = new CannedFileSystemAbstraction(true, null, new IOException("cannot open lock file"), true, CannedFileSystemAbstraction.NOTHING);
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        File storeDir = target.cleanDirectory("unused");
        try {
            storeLocker.checkLock(storeDir);
            Assert.fail();
        }
        catch (StoreLockException e) {
            String msg = String.format("Unable to obtain lock on store lock file: %s. Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", new File(storeDir, "store_lock"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)msg));
        }
    }

    @Test
    public void shouldNotObtainLockWhenStoreAlreadyInUse() throws Exception {
        CannedFileSystemAbstraction fileSystemAbstraction = new CannedFileSystemAbstraction(true, null, null, false, CannedFileSystemAbstraction.NOTHING);
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        try {
            storeLocker.checkLock(target.cleanDirectory("unused"));
            Assert.fail();
        }
        catch (StoreLockException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unable to obtain lock on store lock file"));
        }
    }
}

