/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardOperationsCountException;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestGuard {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testGuardNotInsertedByDefault() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            this.getGuard(db);
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void testGuardInsertedByDefault() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        Assert.assertNotNull((Object)this.getGuard(db));
        db.shutdown();
    }

    @Test
    public void testGuardOnDifferentGraphOps() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        try (Transaction ignored = db.beginTx();){
            this.getGuard(db).startOperationsCount(Integer.MAX_VALUE);
            db.createNode();
            db.createNode();
            db.createNode();
            Guard.OperationsCount ops1 = (Guard.OperationsCount)this.getGuard(db).stop();
            Assert.assertEquals((long)3L, (long)ops1.getOpsCount());
            this.getGuard(db).startOperationsCount(Integer.MAX_VALUE);
            Node n0 = db.getNodeById(0L);
            Node n1 = db.getNodeById(1L);
            db.getNodeById(2L);
            Guard.OperationsCount ops2 = (Guard.OperationsCount)this.getGuard(db).stop();
            Assert.assertEquals((long)3L, (long)ops2.getOpsCount());
            this.getGuard(db).startOperationsCount(Integer.MAX_VALUE);
            n0.createRelationshipTo(n1, (RelationshipType)DynamicRelationshipType.withName((String)"REL"));
            Guard.OperationsCount ops3 = (Guard.OperationsCount)this.getGuard(db).stop();
            Assert.assertEquals((long)2L, (long)ops3.getOpsCount());
            this.getGuard(db).startOperationsCount(Integer.MAX_VALUE);
            for (Path position : Traversal.description().breadthFirst().relationships((RelationshipType)DynamicRelationshipType.withName((String)"REL")).traverse(n0)) {
                SillyUtils.ignore((Object)position);
            }
            Guard.OperationsCount ops4 = (Guard.OperationsCount)this.getGuard(db).stop();
            Assert.assertEquals((long)1L, (long)ops4.getOpsCount());
        }
        db.shutdown();
    }

    @Test
    public void testOpsCountGuardFail() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        Guard guard = this.getGuard(db);
        guard.startOperationsCount(2L);
        try (Transaction ignored = db.beginTx();){
            db.createNode();
            db.createNode();
            try {
                db.createNode();
                Assert.fail();
            }
            catch (GuardOperationsCountException e) {
                // empty catch block
            }
        }
        db.shutdown();
    }

    @Test
    public void testTimeoutGuardFail() throws InterruptedException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        ((Guard)db.getDependencyResolver().resolveDependency(Guard.class)).startTimeout(50L);
        try (Transaction ignore = db.beginTx();){
            Thread.sleep(100L);
            try {
                db.createNode();
                Assert.fail((String)"Expected guard to stop this");
            }
            catch (GuardTimeoutException e) {
                // empty catch block
            }
        }
        db.shutdown();
    }

    @Test
    public void testTimeoutGuardPass() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.execution_guard_enabled, "true").newGraphDatabase();
        int timeout = 1000;
        this.getGuard(db).startTimeout((long)timeout);
        try (Transaction ignored = db.beginTx();){
            db.createNode();
        }
        db.shutdown();
    }

    private Guard getGuard(GraphDatabaseAPI db) {
        return (Guard)db.getDependencyResolver().resolveDependency(Guard.class);
    }
}

