/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class TestPlaceboTransaction {
    private Transaction mockTopLevelTx;
    private PlaceboTransaction placeboTx;
    private Node resource;
    private PersistenceManager persistenceManager;
    private ReadOperations readOps;

    @Before
    public void before() throws Exception {
        AbstractTransactionManager mockTxManager = (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class);
        this.mockTopLevelTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)mockTxManager.getTransaction()).thenReturn((Object)this.mockTopLevelTx);
        this.persistenceManager = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        ThreadToStatementContextBridge stmtProvider = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        this.readOps = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)stmtProvider.instance()).thenReturn((Object)stmt);
        Mockito.when((Object)stmt.readOperations()).thenReturn((Object)this.readOps);
        this.placeboTx = new PlaceboTransaction(mockTxManager, stmtProvider);
        this.resource = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.resource.getId()).thenReturn((Object)1L);
    }

    @Test
    public void shouldRollbackParentByDefault() throws SystemException {
        this.placeboTx.finish();
        ((Transaction)Mockito.verify((Object)this.mockTopLevelTx)).setRollbackOnly();
    }

    @Test
    public void shouldRollbackParentIfFailureCalled() throws SystemException {
        this.placeboTx.failure();
        this.placeboTx.finish();
        ((Transaction)Mockito.verify((Object)this.mockTopLevelTx)).setRollbackOnly();
    }

    @Test
    public void shouldNotRollbackParentIfSuccessCalled() throws SystemException {
        this.placeboTx.success();
        this.placeboTx.finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTopLevelTx});
    }

    @Test
    public void successCannotOverrideFailure() throws Exception {
        this.placeboTx.failure();
        this.placeboTx.success();
        this.placeboTx.finish();
        ((Transaction)Mockito.verify((Object)this.mockTopLevelTx)).setRollbackOnly();
    }

    @Test
    public void canAcquireReadLock() throws Exception {
        this.placeboTx.acquireReadLock((PropertyContainer)this.resource);
        ((ReadOperations)Mockito.verify((Object)this.readOps)).acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void canAcquireWriteLock() throws Exception {
        this.placeboTx.acquireWriteLock((PropertyContainer)this.resource);
        ((ReadOperations)Mockito.verify((Object)this.readOps)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }
}

