/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class TestTransactionEventDeadlocks {
    @Rule
    public DatabaseRule database = new ImpermanentDatabaseRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canAvoidDeadlockThatWouldHappenIfTheRelationshipTypeCreationTransactionModifiedData() throws Exception {
        GraphDatabaseService graphdb = this.database.getGraphDatabaseService();
        Transaction tx = graphdb.beginTx();
        final Node root = graphdb.createNode();
        try {
            root.setProperty("counter", (Object)0L);
            tx.success();
        }
        finally {
            tx.finish();
        }
        graphdb.registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler<Void>(){

            public Void beforeCommit(TransactionData data) throws Exception {
                if (IteratorUtil.count((Iterable)data.createdRelationships()) == 0) {
                    return null;
                }
                root.setProperty("counter", (Object)((Long)root.removeProperty("counter") + 1L));
                return null;
            }

            public void afterCommit(TransactionData data, Void state) {
            }

            public void afterRollback(TransactionData data, Void state) {
            }
        });
        tx = graphdb.beginTx();
        try {
            root.setProperty("state", (Object)"not broken yet");
            root.createRelationshipTo(graphdb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
            root.removeProperty("state");
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((Object)root, Neo4jMatchers.inTx(graphdb, Neo4jMatchers.hasProperty("counter").withValue(1L)));
    }
}

