/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;

public class WindowPoolConfigurationIT {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(WindowPoolConfigurationIT.class);

    @Test
    public void testTinyStoreWithLessMemory() throws IOException {
        this.verifyPersistenceWindowPoolCanBeConfigured(100, 0.9);
    }

    @Test
    public void testTinyStoreWithMoreMemory() throws IOException {
        this.verifyPersistenceWindowPoolCanBeConfigured(100, 1.1);
    }

    @Test
    public void testSmallStoreWithLessMemory() throws IOException {
        this.verifyPersistenceWindowPoolCanBeConfigured(1000, 0.9);
    }

    @Test
    public void testSmallStoreWithMoreMemory() throws IOException {
        this.verifyPersistenceWindowPoolCanBeConfigured(1000, 1.1);
    }

    @Test
    public void testMediumStoreWithLessMemory() throws IOException {
        this.verifyPersistenceWindowPoolCanBeConfigured(10000, 0.9);
    }

    @Test
    public void testMediumStoreWithMoreMemory() throws IOException {
        this.verifyPersistenceWindowPoolCanBeConfigured(10000, 1.1);
    }

    private void verifyPersistenceWindowPoolCanBeConfigured(int nodeCount, double memoryFactor) throws IOException {
        File dir = this.testDirectory.directory();
        FileUtils.deleteRecursively((File)dir);
        dir.mkdirs();
        this.setUpTestData(dir, nodeCount);
        this.initializeDatabaseWithTestConfiguration(dir, nodeCount, memoryFactor);
    }

    private void setUpTestData(File dir, int nodeCount) {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir.getAbsolutePath()).newGraphDatabase();
        this.createTestData(db, nodeCount);
        db.shutdown();
    }

    private void createTestData(GraphDatabaseService db, int nodeCount) {
        Transaction tx = db.beginTx();
        for (int j = 0; j < nodeCount; ++j) {
            db.createNode();
        }
        tx.success();
        tx.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDatabaseWithTestConfiguration(File dir, int nodeCount, double memoryFactor) {
        int nodeStoreMappedBytes = (int)((double)(nodeCount * 15) * memoryFactor) - 7;
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir.getAbsolutePath()).setConfig(GraphDatabaseSettings.nodestore_mapped_memory_size, "" + nodeStoreMappedBytes).setConfig(GraphDatabaseSettings.cache_type, "none").newGraphDatabase();
        Transaction tx = db.beginTx();
        try {
            Node node = db.getNodeById((long)(nodeCount - 1));
            Assert.assertNotNull((Object)node);
            tx.success();
        }
        finally {
            tx.finish();
            db.shutdown();
        }
    }
}

