/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class NonUniqueIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public NonUniqueIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite);
    }

    @Test
    public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, new IndexConfiguration(false));
        populator.create();
        populator.add(1L, (Object)"value1");
        populator.add(2L, (Object)"value1");
        populator.close(true);
        IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, new IndexConfiguration(false));
        try (IndexReader reader = accessor.newReader();){
            PrimitiveLongIterator nodes = reader.lookup((Object)"value1");
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{1L, 2L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)nodes));
        }
        accessor.close();
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, new IndexConfiguration(false));
        String failure = "The contrived failure";
        populator.markAsFailed(failure);
        Assert.assertEquals((Object)failure, (Object)this.indexProvider.getPopulationFailure(17L));
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, new IndexConfiguration(false));
        String failure = "The contrived failure";
        populator.markAsFailed(failure);
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(17L));
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() throws Exception {
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, new IndexConfiguration(false));
        populator.close(false);
        populator.drop();
    }

    @Test
    public void shouldApplyUpdatesIdempotently() throws Exception {
        IndexPopulator populator = this.indexProvider.getPopulator(13L, this.descriptor, new IndexConfiguration(false));
        populator.create();
        long nodeId = 1L;
        int propertyKeyId = 10;
        int labelId = 11;
        String propertyValue = "value1";
        PropertyAccessor propertyAccessor = new PropertyAccessor(){

            public Property getProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException, PropertyNotFoundException {
                return Property.stringProperty((int)propertyKeyId, (String)"value1");
            }
        };
        populator.add(nodeId, (Object)"value1");
        try (IndexUpdater updater = populator.newPopulatingUpdater(propertyAccessor);){
            updater.process(NodePropertyUpdate.add((long)nodeId, (int)propertyKeyId, (Object)"value1", (long[])new long[]{labelId}));
        }
        populator.close(true);
        IndexAccessor accessor = this.indexProvider.getOnlineAccessor(13L, new IndexConfiguration(false));
        try (IndexReader reader = accessor.newReader();){
            PrimitiveLongIterator nodes = reader.lookup((Object)"value1");
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{1L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)nodes));
        }
        accessor.close();
    }
}

