/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class UniqueIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public UniqueIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite);
    }

    @Test
    public void shouldProvidePopulatorThatEnforcesUniqueConstraints() throws Exception {
        String value = "value1";
        int nodeId1 = 1;
        int nodeId2 = 2;
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, new IndexConfiguration(true));
        populator.create();
        populator.add((long)nodeId1, (Object)value);
        populator.add((long)nodeId2, (Object)value);
        try {
            PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
            int propertyKeyId = this.descriptor.getPropertyKeyId();
            Mockito.when((Object)propertyAccessor.getProperty((long)nodeId1, propertyKeyId)).thenReturn((Object)Property.stringProperty((int)propertyKeyId, (String)value));
            Mockito.when((Object)propertyAccessor.getProperty((long)nodeId2, propertyKeyId)).thenReturn((Object)Property.stringProperty((int)propertyKeyId, (String)value));
            populator.verifyDeferredConstraints(propertyAccessor);
            Assert.fail((String)"expected exception");
        }
        catch (PreexistingIndexEntryConflictException conflict) {
            Assert.assertEquals((long)nodeId1, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)value, (Object)conflict.getPropertyValue());
            Assert.assertEquals((long)nodeId2, (long)conflict.getAddedNodeId());
        }
    }
}

