/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

@RequiresPersistentGraphDatabase(value=false)
public abstract class AbstractNeo4jTestCase {
    protected static final File NEO4J_BASE_DIR = new File("target", "var");
    @ClassRule
    public static final TestRule START_GRAPHDB = new TestRule(){

        public Statement apply(Statement base, Description description) {
            AbstractNeo4jTestCase.tearDownDb();
            AbstractNeo4jTestCase.setupGraphDatabase(description.getTestClass().getName(), description.getTestClass().getAnnotation(RequiresPersistentGraphDatabase.class).value());
            return base;
        }
    };
    private static ThreadLocal<GraphDatabaseAPI> threadLocalGraphDb = new ThreadLocal();
    private static ThreadLocal<String> currentTestClassName = new ThreadLocal();
    private static ThreadLocal<Boolean> requiresPersistentGraphDatabase = new ThreadLocal();
    private GraphDatabaseAPI graphDb = threadLocalGraphDb.get();
    private Transaction tx;

    protected AbstractNeo4jTestCase() {
    }

    public GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    private static void setupGraphDatabase(String testClassName, boolean requiresPersistentGraphDatabase) {
        AbstractNeo4jTestCase.requiresPersistentGraphDatabase.set(requiresPersistentGraphDatabase);
        currentTestClassName.set(testClassName);
        if (requiresPersistentGraphDatabase) {
            try {
                FileUtils.deleteRecursively((File)new File(AbstractNeo4jTestCase.getStorePath("neo-test")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        threadLocalGraphDb.set((GraphDatabaseAPI)(requiresPersistentGraphDatabase ? new TestGraphDatabaseFactory().newEmbeddedDatabase(AbstractNeo4jTestCase.getStorePath("neo-test")) : new TestGraphDatabaseFactory().newImpermanentDatabase()));
    }

    public GraphDatabaseAPI getGraphDbAPI() {
        return this.graphDb;
    }

    protected boolean restartGraphDbBetweenTests() {
        return false;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public static String getStorePath(String endPath) {
        return new File(NEO4J_BASE_DIR, currentTestClassName.get() + "-" + endPath).getAbsolutePath();
    }

    @Before
    public void setUpTest() {
        if (this.restartGraphDbBetweenTests() && this.graphDb == null) {
            AbstractNeo4jTestCase.setupGraphDatabase(currentTestClassName.get(), requiresPersistentGraphDatabase.get());
            this.graphDb = threadLocalGraphDb.get();
        }
        this.tx = this.graphDb.beginTx();
    }

    @After
    public void tearDownTest() {
        if (this.tx != null) {
            this.tx.finish();
        }
        if (this.restartGraphDbBetweenTests()) {
            AbstractNeo4jTestCase.tearDownDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownDb() {
        try {
            if (threadLocalGraphDb.get() != null) {
                threadLocalGraphDb.get().shutdown();
            }
        }
        finally {
            threadLocalGraphDb.remove();
        }
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public Transaction newTransaction() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.finish();
        }
        this.tx = this.graphDb.beginTx();
        return this.tx;
    }

    public void commit() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.finish();
            this.tx = null;
        }
    }

    public void finish() {
        if (this.tx != null) {
            this.tx.finish();
            this.tx = null;
        }
    }

    public void rollback() {
        if (this.tx != null) {
            this.tx.failure();
            this.tx.finish();
            this.tx = null;
        }
    }

    public NodeManager getNodeManager() {
        return (NodeManager)this.graphDb.getDependencyResolver().resolveDependency(NodeManager.class);
    }

    public static void deleteFileOrDirectory(String dir) {
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(dir));
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractNeo4jTestCase.deleteFileOrDirectory(child);
            }
        } else {
            file.delete();
        }
    }

    protected void clearCache() {
        ((NodeManager)this.getGraphDbAPI().getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
    }

    protected long propertyRecordsInUse() {
        return this.propertyStore().getNumberOfIdsInUse();
    }

    protected long dynamicStringRecordsInUse() {
        return this.dynamicRecordsInUse("stringPropertyStore");
    }

    protected long dynamicArrayRecordsInUse() {
        return this.dynamicRecordsInUse("arrayPropertyStore");
    }

    private long dynamicRecordsInUse(String fieldName) {
        try {
            Field storeField = PropertyStore.class.getDeclaredField(fieldName);
            storeField.setAccessible(true);
            return ((AbstractDynamicStore)storeField.get(this.propertyStore())).getNumberOfIdsInUse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PropertyStore propertyStore() {
        XaDataSourceManager dsMgr = (XaDataSourceManager)this.graphDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class);
        return dsMgr.getNeoStoreDataSource().getXaConnection().getPropertyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(Class<?> testClass, String resource) throws IOException {
        File dir = TargetDirectory.forTest(testClass).makeGraphDbDir();
        try (InputStream source = testClass.getResourceAsStream(resource);){
            if (source == null) {
                throw new FileNotFoundException("Could not find resource '" + resource + "' to unzip");
            }
            ZipInputStream zipStream = new ZipInputStream(source);
            ZipEntry entry = null;
            byte[] scratch = new byte[8096];
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    new File(dir, entry.getName()).mkdirs();
                } else {
                    try (BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(new File(dir, entry.getName())));){
                        int read;
                        for (long toCopy = entry.getSize(); toCopy > 0L; toCopy -= (long)read) {
                            read = zipStream.read(scratch);
                            ((OutputStream)file).write(scratch, 0, read);
                        }
                    }
                }
                zipStream.closeEntry();
            }
        }
        return dir;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface RequiresPersistentGraphDatabase {
        public boolean value() default true;
    }
}

