/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.test.ImpermanentDatabaseRule;

public class KernelSchemaStateFlushingTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private GraphDatabaseAPI db;
    private ThreadToStatementContextBridge ctxProvider;
    private PersistenceManager persistenceManager;

    @Test
    public void shouldKeepSchemaStateIfSchemaIsNotModified() {
        String before = this.commitToSchemaState("test", "before");
        Assert.assertEquals((Object)"before", (Object)before);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"before", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnCreateIndex() throws Exception {
        this.commitToSchemaState("test", "before");
        IndexDescriptor descriptor = this.createIndex();
        this.awaitIndexOnline(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnDropIndex() throws Exception {
        IndexDescriptor descriptor = this.createIndex();
        this.awaitIndexOnline(descriptor);
        this.commitToSchemaState("test", "before");
        this.dropIndex(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnCreateConstraint() throws Exception {
        this.commitToSchemaState("test", "before");
        this.createConstraint();
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnDropConstraint() throws Exception {
        UniquenessConstraint descriptor = this.createConstraint();
        this.commitToSchemaState("test", "before");
        this.dropConstraint(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    private UniquenessConstraint createConstraint() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            UniquenessConstraint descriptor;
            try (Statement statement = this.ctxProvider.instance();){
                descriptor = statement.schemaWriteOperations().uniquenessConstraintCreate(1, 1);
            }
            tx.success();
            UniquenessConstraint uniquenessConstraint = descriptor;
            return uniquenessConstraint;
        }
    }

    private void dropConstraint(UniquenessConstraint descriptor) throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            try (Statement statement = this.ctxProvider.instance();){
                statement.schemaWriteOperations().constraintDrop(descriptor);
            }
            tx.success();
        }
    }

    private IndexDescriptor createIndex() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            IndexDescriptor descriptor;
            try (Statement statement = this.ctxProvider.instance();){
                descriptor = statement.schemaWriteOperations().indexCreate(1, 1);
            }
            tx.success();
            IndexDescriptor indexDescriptor = descriptor;
            return indexDescriptor;
        }
    }

    private void dropIndex(IndexDescriptor descriptor) throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            try (Statement statement = this.ctxProvider.instance();){
                statement.schemaWriteOperations().indexDrop(descriptor);
            }
            tx.success();
        }
    }

    private void awaitIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try (Transaction tx = this.db.beginTx();){
            try (Statement statement = this.ctxProvider.instance();){
                SchemaIndexTestHelper.awaitIndexOnline(statement.readOperations(), descriptor);
            }
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String commitToSchemaState(String key, String value) {
        Throwable throwable = null;
        try (Transaction tx = this.db.beginTx();){
            String string;
            KernelTransaction txc = this.persistenceManager.currentKernelTransactionForWriting();
            try {
                String result;
                string = result = this.getOrCreateFromState(txc, key, value);
            }
            catch (Throwable throwable2) {
                try {
                    tx.success();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            tx.success();
            return string;
        }
    }

    private String getOrCreateFromState(KernelTransaction tx, String key, final String value) {
        try (Statement statement = tx.acquireStatement();){
            String string = (String)statement.readOperations().schemaStateGetOrCreate((Object)key, (Function)new Function<String, String>(){

                public String apply(String from) {
                    return value;
                }
            });
            return string;
        }
    }

    @Before
    public void setup() {
        this.db = this.dbRule.getGraphDatabaseAPI();
        this.persistenceManager = (PersistenceManager)this.db.getDependencyResolver().resolveDependency(PersistenceManager.class);
        this.ctxProvider = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    @After
    public void after() {
        this.db.shutdown();
    }
}

