/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

public class KernelStatementTest {
    @Test
    public void shouldCloseOpenedLabelScanReader() throws Exception {
        LabelScanStore scanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        LabelScanReader scanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
        Mockito.when((Object)scanStore.newReader()).thenReturn((Object)scanReader);
        KernelStatement statement = new KernelStatement((KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class), (IndexReaderFactory)Mockito.mock(IndexReaderFactory.class), scanStore, null, null, null, null);
        statement.acquire();
        LabelScanReader actualReader = statement.getLabelScanReader();
        Assert.assertEquals((Object)scanReader, (Object)actualReader);
        statement.close();
        ((LabelScanStore)Mockito.verify((Object)scanStore)).newReader();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{scanStore});
        ((LabelScanReader)Mockito.verify((Object)scanReader)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{scanReader});
    }
}

