/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class LockingStatementOperationsTest {
    private final LockingStatementOperations lockingOps;
    private final EntityWriteOperations entityWriteOps;
    private final SchemaReadOperations schemaReadOps;
    private final SchemaWriteOperations schemaWriteOps;
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final InOrder order;
    private final KernelStatement state = new KernelStatement(null, null, null, null, this.locks, null, null);

    public LockingStatementOperationsTest() {
        this.entityWriteOps = (EntityWriteOperations)Mockito.mock(EntityWriteOperations.class);
        this.schemaReadOps = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        this.schemaWriteOps = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks, this.entityWriteOps, this.schemaReadOps, this.schemaWriteOps});
        this.lockingOps = new LockingStatementOperations(this.entityWriteOps, this.schemaReadOps, this.schemaWriteOps, null);
    }

    @Test
    public void shouldAcquireEntityWriteLockCreatingRelationship() throws Exception {
        this.lockingOps.relationshipCreate(this.state, 1, 2L, 3L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).relationshipCreate(this.state, 1, 2L, 3L);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeAddingLabelToNode() throws Exception {
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeAddingLabelToNode() throws Exception {
        this.lockingOps.nodeAddLabel(this.state, 123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeAddLabel(this.state, 123L, 456);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnNode() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeSettingPropertyOnNode() throws Exception {
        DefinedProperty property = Property.property((int)8, (Object)9);
        this.lockingOps.nodeSetProperty(this.state, 123L, property);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeSetProperty(this.state, 123L, property);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeDeletingNode() {
        this.lockingOps.nodeDelete(this.state, 123L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((EntityWriteOperations)this.order.verify((Object)this.entityWriteOps)).nodeDelete(this.state, 123L);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeAddingIndexRule() throws Exception {
        IndexDescriptor rule = (IndexDescriptor)Mockito.mock(IndexDescriptor.class);
        Mockito.when((Object)this.schemaWriteOps.indexCreate(this.state, 123, 456)).thenReturn((Object)rule);
        IndexDescriptor result = this.lockingOps.indexCreate(this.state, 123, 456);
        Assert.assertSame((Object)rule, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).indexCreate(this.state, 123, 456);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeRemovingIndexRule() throws Exception {
        IndexDescriptor rule = new IndexDescriptor(0, 0);
        this.lockingOps.indexDrop(this.state, rule);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).indexDrop(this.state, rule);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingIndexRules() throws Exception {
        Iterator rules = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.indexesGetAll(this.state)).thenReturn(rules);
        Iterator result = this.lockingOps.indexesGetAll(this.state);
        Assert.assertSame(rules, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).indexesGetAll(this.state);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeCreatingUniquenessConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(0, 0);
        Mockito.when((Object)this.schemaWriteOps.uniquenessConstraintCreate(this.state, 123, 456)).thenReturn((Object)constraint);
        UniquenessConstraint result = this.lockingOps.uniquenessConstraintCreate(this.state, 123, 456);
        Assert.assertSame((Object)constraint, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).uniquenessConstraintCreate(this.state, 123, 456);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeDroppingConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(1, 2);
        this.lockingOps.constraintDrop(this.state, constraint);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaWriteOperations)this.order.verify((Object)this.schemaWriteOps)).constraintDrop(this.state, constraint);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabelAndProperty() throws Exception {
        Iterator constraints = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.constraintsGetForLabelAndPropertyKey(this.state, 123, 456)).thenReturn(constraints);
        Iterator result = this.lockingOps.constraintsGetForLabelAndPropertyKey(this.state, 123, 456);
        Assert.assertSame(constraints, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetForLabelAndPropertyKey(this.state, 123, 456);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabel() throws Exception {
        Iterator constraints = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.constraintsGetForLabel(this.state, 123)).thenReturn(constraints);
        Iterator result = this.lockingOps.constraintsGetForLabel(this.state, 123);
        Assert.assertSame(constraints, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetForLabel(this.state, 123);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingAllConstraints() throws Exception {
        Iterator constraints = Collections.emptyIterator();
        Mockito.when((Object)this.schemaReadOps.constraintsGetAll(this.state)).thenReturn(constraints);
        Iterator result = this.lockingOps.constraintsGetAll(this.state);
        Assert.assertSame(constraints, (Object)result);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
        ((SchemaReadOperations)this.order.verify((Object)this.schemaReadOps)).constraintsGetAll(this.state);
    }
}

