/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;

public class PropertyTransactionStateTest {
    private GraphDatabaseService db;

    @Before
    public void setUp() throws Exception {
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @Test
    public void testUpdateDoubleArrayProperty() throws Exception {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            node.setProperty("foo", (Object)new double[]{0.0, 0.0, 0.0, 0.0});
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            for (int i = 0; i < 100; ++i) {
                double[] data = (double[])node.getProperty("foo");
                data[2] = i;
                data[3] = i;
                node.setProperty("foo", (Object)data);
                Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, i, i}, (double[])((double[])node.getProperty("foo")), (double)0.1);
            }
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testStringPropertyUpdate() throws Exception {
        Node node;
        String key = "foo";
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            node.setProperty(key, (Object)"one");
            tx.success();
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            node.setProperty(key, (Object)"one");
            node.setProperty(key, (Object)"two");
            Assert.assertEquals((Object)"two", (Object)node.getProperty(key));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testSetDoubleArrayProperty() throws Exception {
        this.db.beginTx();
        Node node = this.db.createNode();
        for (int i = 0; i < 100; ++i) {
            node.setProperty("foo", (Object)new double[]{0.0, 0.0, i, i});
            Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, i, i}, (double[])((double[])node.getProperty("foo")), (double)0.1);
        }
    }
}

