/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.Locks;

public abstract class StatementOperationsTestHelper {
    public static StatementOperationParts mockedParts() {
        return new StatementOperationParts((KeyReadOperations)Mockito.mock(KeyReadOperations.class), (KeyWriteOperations)Mockito.mock(KeyWriteOperations.class), (EntityReadOperations)Mockito.mock(EntityReadOperations.class), (EntityWriteOperations)Mockito.mock(EntityWriteOperations.class), (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class), (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class), (SchemaStateOperations)Mockito.mock(SchemaStateOperations.class), (LockOperations)Mockito.mock(LockOperations.class));
    }

    public static KernelStatement mockedState() {
        return StatementOperationsTestHelper.mockedState((TxState)Mockito.mock(TxState.class));
    }

    public static KernelStatement mockedState(final TxState txState) {
        KernelStatement state = (KernelStatement)Mockito.mock(KernelStatement.class);
        Locks.Client lockHolder = (Locks.Client)Mockito.mock(Locks.Client.class);
        try {
            IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
            Mockito.when((Object)indexReader.lookup(Matchers.any())).thenReturn((Object)PrimitiveLongCollections.emptyIterator());
            Mockito.when((Object)state.getIndexReader(Matchers.anyLong())).thenReturn((Object)indexReader);
        }
        catch (IndexNotFoundKernelException e) {
            throw new Error(e);
        }
        Mockito.when((Object)state.txState()).thenReturn((Object)txState);
        Mockito.when((Object)state.hasTxState()).thenReturn((Object)true);
        Mockito.when((Object)state.hasTxStateWithChanges()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return txState.hasChanges();
            }
        });
        Mockito.when((Object)state.locks()).thenReturn((Object)lockHolder);
        return state;
    }

    private StatementOperationsTestHelper() {
    }
}

