/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.Transactor;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

public class TransactorTest {
    private final AbstractTransactionManager txManager = (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class);
    private final PersistenceManager pm = (PersistenceManager)Mockito.mock(PersistenceManager.class);
    private final Statement statement = (Statement)Mockito.mock(Statement.class);
    private final KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final Transactor.Work<Object, KernelException> work = (Transactor.Work)Mockito.mock(Transactor.Work.class);
    private final Transactor transactor = new Transactor((TransactionManager)this.txManager, this.pm);

    @Test
    public void shouldCommitSuccessfulStatement() throws Exception {
        Transaction existingTransaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.txManager.suspend()).thenReturn((Object)existingTransaction);
        Mockito.when((Object)this.pm.currentKernelTransactionForWriting()).thenReturn((Object)this.kernelTransaction);
        Mockito.when((Object)this.kernelTransaction.acquireStatement()).thenReturn((Object)this.statement);
        Object expectedResult = new Object();
        Mockito.when((Object)this.work.perform(this.statement)).thenReturn(expectedResult);
        Object result = this.transactor.execute(this.work);
        Assert.assertEquals((Object)expectedResult, (Object)result);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.txManager, this.pm, this.kernelTransaction});
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).suspend();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).begin();
        ((PersistenceManager)order.verify((Object)this.pm)).currentKernelTransactionForWriting();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).commit();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).resume(existingTransaction);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldRollbackFailingStatement() throws Exception {
        Transaction existingTransaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.txManager.suspend()).thenReturn((Object)existingTransaction);
        Mockito.when((Object)this.pm.currentKernelTransactionForWriting()).thenReturn((Object)this.kernelTransaction);
        Mockito.when((Object)this.kernelTransaction.acquireStatement()).thenReturn((Object)this.statement);
        SpecificKernelException exception = new SpecificKernelException();
        Mockito.when((Object)this.work.perform((Statement)Matchers.any(KernelStatement.class))).thenThrow(new Throwable[]{exception});
        try {
            this.transactor.execute(this.work);
            Assert.fail((String)"expected exception");
        }
        catch (SpecificKernelException e) {
            Assert.assertSame((Object)((Object)exception), (Object)((Object)e));
        }
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.txManager, this.pm, this.kernelTransaction, this.work});
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).suspend();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).begin();
        ((PersistenceManager)order.verify((Object)this.pm)).currentKernelTransactionForWriting();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).rollback();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).resume(existingTransaction);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldNotResumeATransactionIfThereWasNoTransactionSuspended() throws Exception {
        Mockito.when((Object)this.txManager.suspend()).thenReturn(null);
        Mockito.when((Object)this.pm.currentKernelTransactionForWriting()).thenReturn((Object)this.kernelTransaction);
        Mockito.when((Object)this.kernelTransaction.acquireStatement()).thenReturn((Object)this.statement);
        Object expectedResult = new Object();
        Mockito.when((Object)this.work.perform(this.statement)).thenReturn(expectedResult);
        Object result = this.transactor.execute(this.work);
        Assert.assertEquals((Object)expectedResult, (Object)result);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.txManager, this.pm, this.kernelTransaction, this.work});
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).suspend();
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).begin();
        ((PersistenceManager)order.verify((Object)this.pm)).currentKernelTransactionForWriting();
        ((Transactor.Work)order.verify(this.work)).perform(this.statement);
        ((AbstractTransactionManager)order.verify((Object)this.txManager)).commit();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldPropagateNotSupportedExceptionFromBegin() throws Exception {
        Mockito.when((Object)this.txManager.suspend()).thenReturn(Mockito.mock(Transaction.class));
        NotSupportedException exception = new NotSupportedException();
        ((AbstractTransactionManager)Mockito.doThrow((Throwable)exception).when((Object)this.txManager)).begin();
        try {
            this.transactor.execute(this.work);
            Assert.fail((String)"expected exception");
        }
        catch (TransactionFailureException e) {
            Assert.assertSame((Object)exception, (Object)e.getCause().getCause());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.work});
        ((AbstractTransactionManager)Mockito.verify((Object)this.txManager)).suspend();
        ((AbstractTransactionManager)Mockito.verify((Object)this.txManager)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.txManager});
    }

    @Test
    public void shouldPropagateSystemExceptionFromBegin() throws Exception {
        Mockito.when((Object)this.txManager.suspend()).thenReturn(Mockito.mock(Transaction.class));
        SystemException exception = new SystemException();
        ((AbstractTransactionManager)Mockito.doThrow((Throwable)exception).when((Object)this.txManager)).begin();
        try {
            this.transactor.execute(this.work);
            Assert.fail((String)"expected exception");
        }
        catch (TransactionFailureException e) {
            Assert.assertSame((Object)exception, (Object)e.getCause().getCause());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.work});
        ((AbstractTransactionManager)Mockito.verify((Object)this.txManager)).suspend();
        ((AbstractTransactionManager)Mockito.verify((Object)this.txManager)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.txManager});
    }

    @Test
    public void shouldPropagateSystemExceptionFromSuspendTransaction() throws Exception {
        SystemException exception = new SystemException();
        ((AbstractTransactionManager)Mockito.doThrow((Throwable)exception).when((Object)this.txManager)).suspend();
        try {
            this.transactor.execute(this.work);
            Assert.fail((String)"expected exception");
        }
        catch (TransactionFailureException e) {
            Assert.assertSame((Object)exception, (Object)e.getCause());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.work});
        ((AbstractTransactionManager)Mockito.verify((Object)this.txManager)).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.txManager});
    }

    @Test
    public void shouldPropagateSystemExceptionFromResumeTransaction() throws Exception {
        SystemException exception = new SystemException();
        ((AbstractTransactionManager)Mockito.doThrow((Throwable)exception).when((Object)this.txManager)).suspend();
        try {
            this.transactor.execute(this.work);
            Assert.fail((String)"expected exception");
        }
        catch (TransactionFailureException e) {
            Assert.assertSame((Object)exception, (Object)e.getCause());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.work});
    }

    private static class SpecificKernelException
    extends KernelException {
        protected SpecificKernelException() {
            super((Status)Status.General.UnknownFailure, "very specific", new Object[0]);
        }
    }
}

