/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.core.Transactor;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;

public class ConstraintIndexCreatorTest {
    @Test
    public void shouldCreateIndexInAnotherTransaction() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubTransactor transactor = new StubTransactor();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getProxyForRule(2468L)).thenReturn((Object)indexProxy);
        ConstraintIndexCreator creator = new ConstraintIndexCreator((Transactor)transactor, indexingService);
        long indexId = creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), 123, 456);
        Assert.assertEquals((long)2468L, (long)indexId);
        Assert.assertEquals((long)1L, (long)transactor.transactions.size());
        ((TxState)Mockito.verify((Object)transactor.transactions.get(0).txState())).constraintIndexRuleDoAdd(descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexCreationContext.schemaWriteOperations()});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldDropIndexIfPopulationFails() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubTransactor transactor = new StubTransactor();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getProxyForRule(2468L)).thenReturn((Object)indexProxy);
        PreexistingIndexEntryConflictException cause = new PreexistingIndexEntryConflictException((Object)"a", 2L, 1L);
        ((IndexProxy)Mockito.doThrow((Throwable)new IndexPopulationFailedKernelException(descriptor, "some index", (Throwable)cause)).when((Object)indexProxy)).awaitStoreScanCompleted();
        ConstraintIndexCreator creator = new ConstraintIndexCreator((Transactor)transactor, indexingService);
        try {
            creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), 123, 456);
            Assert.fail((String)"expected exception");
        }
        catch (ConstraintVerificationFailedKernelException e) {
            Assert.assertEquals((Object)"Existing data does not satisfy CONSTRAINT ON ( n:label[123] ) ASSERT n.property[456] IS UNIQUE.", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)transactor.transactions.size());
        TxState tx1 = transactor.transactions.get(0).txState();
        ((TxState)Mockito.verify((Object)tx1)).constraintIndexRuleDoAdd(new IndexDescriptor(123, 456));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx1});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        TxState tx2 = transactor.transactions.get(1).txState();
        ((TxState)Mockito.verify((Object)tx2)).constraintIndexDoDrop(new IndexDescriptor(123, 456));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx2});
    }

    @Test
    public void shouldDropIndexInAnotherTransaction() throws Exception {
        StubTransactor transactor = new StubTransactor();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        ConstraintIndexCreator creator = new ConstraintIndexCreator((Transactor)transactor, indexingService);
        creator.dropUniquenessConstraintIndex(descriptor);
        Assert.assertEquals((long)1L, (long)transactor.transactions.size());
        ((TxState)Mockito.verify((Object)transactor.transactions.get(0).txState())).constraintIndexDoDrop(descriptor);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexingService});
    }

    private static class StubTransactor
    extends Transactor {
        final List<KernelStatement> transactions = new ArrayList<KernelStatement>();

        StubTransactor() {
            super(null, null);
        }

        public <RESULT, FAILURE extends KernelException> RESULT execute(Transactor.Work<RESULT, FAILURE> work) throws FAILURE {
            KernelStatement state = StatementOperationsTestHelper.mockedState();
            this.transactions.add(state);
            return (RESULT)work.perform((Statement)state);
        }
    }
}

