/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;

public class IndexPopulationJobTest {
    private ImpermanentGraphDatabase db;
    private final Label FIRST = DynamicLabel.label((String)"FIRST");
    private final Label SECOND = DynamicLabel.label((String)"SECOND");
    private final String name = "name";
    private final String age = "age";
    private ThreadToStatementContextBridge ctxProvider;
    private NeoStoreIndexStoreView indexStoreView;
    private IndexPopulator populator;
    private KernelSchemaStateStore stateHolder;
    private int labelId;

    @Test
    public void shouldPopulateIndexWithOneNode() throws Exception {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, new FlippableIndexProxy());
        job.run();
        ((IndexPopulator)Mockito.verify((Object)this.populator)).create();
        ((IndexPopulator)Mockito.verify((Object)this.populator)).add(nodeId, (Object)value);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).verifyDeferredConstraints((PropertyAccessor)this.indexStoreView);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
    }

    @Test
    public void shouldFlushSchemaStateAfterPopulation() throws Exception {
        String value = "Taylor";
        this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        this.stateHolder.apply(MapUtil.stringMap((String[])new String[]{"key", "original_value"}));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, new FlippableIndexProxy());
        job.run();
        String result = (String)this.stateHolder.get((Object)"key");
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void shouldPopulateIndexWithASmallDataset() throws Exception {
        String value = "Mattias";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.SECOND);
        this.createNode(MapUtil.map((Object[])new Object[]{"age", 31}), this.FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{"age", 35, "name", value}), this.FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, new FlippableIndexProxy());
        job.run();
        ((IndexPopulator)Mockito.verify((Object)this.populator)).create();
        ((IndexPopulator)Mockito.verify((Object)this.populator)).add(node1, (Object)value);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).add(node4, (Object)value);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).verifyDeferredConstraints((PropertyAccessor)this.indexStoreView);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
    }

    @Test
    public void shouldIndexUpdatesWhenDoingThePopulation() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        String changedValue = "changed";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value1}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value2}), this.FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value3}), this.FIRST);
        long changeNode = node1;
        int propertyKeyId = this.getPropertyKeyForName("name");
        NodeChangingWriter populator = new NodeChangingWriter(changeNode, propertyKeyId, value1, changedValue, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", (IndexPopulator)populator, new FlippableIndexProxy());
        populator.setJob(job);
        job.run();
        Set expected = IteratorUtil.asSet((Object[])new Pair[]{Pair.of((Object)node1, (Object)value1), Pair.of((Object)node2, (Object)value2), Pair.of((Object)node3, (Object)value3), Pair.of((Object)node1, (Object)changedValue)});
        Assert.assertEquals((Object)expected, (Object)populator.added);
    }

    @Test
    public void shouldRemoveViaIndexUpdatesWhenDoingThePopulation() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value1}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value2}), this.FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value3}), this.FIRST);
        int propertyKeyId = this.getPropertyKeyForName("name");
        NodeDeletingWriter populator = new NodeDeletingWriter(node2, propertyKeyId, value2, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", (IndexPopulator)populator, new FlippableIndexProxy());
        populator.setJob(job);
        job.run();
        Map expectedAdded = MapUtil.genericMap((Object[])new Object[]{node1, value1, node2, value2, node3, value3});
        Assert.assertEquals((Object)expectedAdded, (Object)populator.added);
        Map expectedRemoved = MapUtil.genericMap((Object[])new Object[]{node2, value2});
        Assert.assertEquals((Object)expectedRemoved, (Object)populator.removed);
    }

    @Test
    public void shouldTransitionToFailedStateIfPopulationJobCrashes() throws Exception {
        IndexPopulator failingPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        ((IndexPopulator)Mockito.doThrow((Throwable)new RuntimeException("BORK BORK")).when((Object)failingPopulator)).add(Mockito.anyLong(), Mockito.any());
        FlippableIndexProxy index = new FlippableIndexProxy();
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", failingPopulator, index);
        job.run();
        MatcherAssert.assertThat((Object)index.getState(), (Matcher)IsEqual.equalTo((Object)InternalIndexState.FAILED));
    }

    @Test
    public void shouldBeAbleToCancelPopulationJob() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        ControlledStoreScan storeScan = new ControlledStoreScan();
        Mockito.when((Object)storeView.visitNodesWithPropertyAndLabel((IndexDescriptor)Mockito.any(IndexDescriptor.class), (Visitor)Matchers.any())).thenReturn((Object)storeScan);
        final IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, index, storeView, StringLogger.DEV_NULL);
        OtherThreadExecutor<Object> populationJobRunner = new OtherThreadExecutor<Object>("Population job test runner", null);
        Future<Void> runFuture = populationJobRunner.executeDontWait(new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) {
                job.run();
                return null;
            }
        });
        storeScan.latch.awaitStart();
        job.cancel().get();
        storeScan.latch.awaitFinish();
        runFuture.get();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)1))).close(false);
        ((FlippableIndexProxy)Mockito.verify((Object)index, (VerificationMode)Mockito.times((int)0))).flip((Callable)Matchers.any(), (FailedIndexProxyFactory)Matchers.any());
    }

    @Test
    public void shouldLogJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        TestLogger logger = new TestLogger();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, index, (IndexStoreView)this.indexStoreView, logger);
        job.run();
        logger.assertExactly(TestLogger.LogCall.info("Index population started: [:FIRST(name)]"), TestLogger.LogCall.info("Index population completed. Index is now online: [:FIRST(name)]"));
    }

    @Test
    public void shouldLogJobFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        TestLogger logger = new TestLogger();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, index, (IndexStoreView)this.indexStoreView, logger);
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.populator)).create();
        job.run();
        logger.assertAtLeastOnce(TestLogger.LogCall.error("Failed to populate index: [:FIRST(name)]", failure));
    }

    @Test
    public void shouldFlipToFailedUsingFailedIndexProxyFactory() throws Exception {
        FailedIndexProxyFactory failureDelegateFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", failureDelegateFactory, this.populator, new FlippableIndexProxy(), (IndexStoreView)this.indexStoreView, new TestLogger());
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.populator)).close(true);
        job.run();
        ((FailedIndexProxyFactory)Mockito.verify((Object)failureDelegateFactory)).create((Throwable)Mockito.any(Throwable.class));
    }

    @Test
    public void shouldCloseAndFailOnFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        TestLogger logger = new TestLogger();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, index, (IndexStoreView)this.indexStoreView, logger);
        String failureMessage = "not successful";
        IllegalStateException failure = new IllegalStateException(failureMessage);
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.populator)).create();
        job.run();
        ((IndexPopulator)Mockito.verify((Object)this.populator)).markAsFailed(Matchers.contains((String)failureMessage));
    }

    @Test
    public void shouldFailIfDeferredConstraintViolated() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        TestLogger logger = new TestLogger();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", this.populator, index, (IndexStoreView)this.indexStoreView, logger);
        PreexistingIndexEntryConflictException failure = new PreexistingIndexEntryConflictException((Object)"duplicate value", 0L, 1L);
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.populator)).verifyDeferredConstraints((PropertyAccessor)this.indexStoreView);
        job.run();
        ((IndexPopulator)Mockito.verify((Object)this.populator)).markAsFailed(Matchers.contains((String)"duplicate value"));
    }

    @Before
    public void before() throws Exception {
        this.db = (ImpermanentGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.ctxProvider = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        this.stateHolder = new KernelSchemaStateStore();
        this.indexStoreView = this.newStoreView();
        try (Transaction tx = this.db.beginTx();){
            Statement statement = this.ctxProvider.instance();
            this.labelId = statement.schemaWriteOperations().labelGetOrCreateForName(this.FIRST.name());
            statement.schemaWriteOperations().labelGetOrCreateForName(this.SECOND.name());
            statement.close();
            tx.success();
        }
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    private IndexPopulationJob newIndexPopulationJob(Label label, String propertyKey, IndexPopulator populator, FlippableIndexProxy flipper) {
        return this.newIndexPopulationJob(label, propertyKey, populator, flipper, (IndexStoreView)this.indexStoreView, StringLogger.DEV_NULL);
    }

    private IndexPopulationJob newIndexPopulationJob(Label label, String propertyKey, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, StringLogger logger) {
        return this.newIndexPopulationJob(label, propertyKey, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class), populator, flipper, storeView, logger);
    }

    private IndexPopulationJob newIndexPopulationJob(Label label, String propertyKey, FailedIndexProxyFactory failureDelegateFactory, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, StringLogger logger) {
        IndexDescriptor descriptor;
        try (Transaction tx = this.db.beginTx();){
            ReadOperations statement = this.ctxProvider.instance().readOperations();
            descriptor = new IndexDescriptor(statement.labelGetForName(label.name()), statement.propertyKeyGetForName(propertyKey));
            tx.success();
        }
        flipper.setFlipTarget((IndexProxyFactory)Mockito.mock(IndexProxyFactory.class));
        return new IndexPopulationJob(descriptor, TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, String.format(":%s(%s)", label.name(), propertyKey), failureDelegateFactory, populator, flipper, storeView, (UpdateableSchemaState)this.stateHolder, (Logging)new SingleLoggingService(logger));
    }

    private long createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private int getPropertyKeyForName(String name) {
        try (Transaction tx = this.db.beginTx();){
            int result = this.ctxProvider.instance().readOperations().propertyKeyGetForName(name);
            tx.success();
            int n = result;
            return n;
        }
    }

    private NeoStoreIndexStoreView newStoreView() {
        return new NeoStoreIndexStoreView((LockService)Mockito.mock(LockService.class, (Answer)Mockito.RETURNS_MOCKS), ((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getNeoStore());
    }

    private class NodeDeletingWriter
    extends IndexPopulator.Adapter {
        private final Map<Long, Object> added = new HashMap<Long, Object>();
        private final Map<Long, Object> removed = new HashMap<Long, Object>();
        private final long nodeToDelete;
        private IndexPopulationJob job;
        private final int propertyKeyId;
        private final Object valueToDelete;
        private final int label;

        public NodeDeletingWriter(long nodeToDelete, int propertyKeyId, Object valueToDelete, int label) {
            this.nodeToDelete = nodeToDelete;
            this.propertyKeyId = propertyKeyId;
            this.valueToDelete = valueToDelete;
            this.label = label;
        }

        public void setJob(IndexPopulationJob job) {
            this.job = job;
        }

        public void add(long nodeId, Object propertyValue) {
            if (nodeId == 2L) {
                this.job.update(NodePropertyUpdate.remove((long)this.nodeToDelete, (int)this.propertyKeyId, (Object)this.valueToDelete, (long[])new long[]{this.label}));
            }
            this.added.put(nodeId, propertyValue);
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) {
            return new IndexUpdater(){

                public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                    switch (update.getUpdateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            NodeDeletingWriter.this.added.put(update.getNodeId(), update.getValueAfter());
                            break;
                        }
                        case REMOVED: {
                            NodeDeletingWriter.this.removed.put(update.getNodeId(), update.getValueBefore());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.getUpdateMode().name());
                        }
                    }
                }

                public void close() throws IOException, IndexEntryConflictException {
                }

                public void remove(Iterable<Long> nodeIds) {
                    throw new UnsupportedOperationException("not expected");
                }
            };
        }
    }

    private class NodeChangingWriter
    extends IndexPopulator.Adapter {
        private final Set<Pair<Long, Object>> added = new HashSet<Pair<Long, Object>>();
        private IndexPopulationJob job;
        private final long nodeToChange;
        private final Object newValue;
        private final Object previousValue;
        private final int label;
        private final int propertyKeyId;

        public NodeChangingWriter(long nodeToChange, int propertyKeyId, Object previousValue, Object newValue, int label) {
            this.nodeToChange = nodeToChange;
            this.propertyKeyId = propertyKeyId;
            this.previousValue = previousValue;
            this.newValue = newValue;
            this.label = label;
        }

        public void add(long nodeId, Object propertyValue) {
            if (nodeId == 2L) {
                long[] labels = new long[]{this.label};
                this.job.update(NodePropertyUpdate.change((long)this.nodeToChange, (int)this.propertyKeyId, (Object)this.previousValue, (long[])labels, (Object)this.newValue, (long[])labels));
            }
            this.added.add((Pair<Long, Object>)Pair.of((Object)nodeId, (Object)propertyValue));
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) {
            return new IndexUpdater(){

                public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                    switch (update.getUpdateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            NodeChangingWriter.this.added.add(Pair.of((Object)update.getNodeId(), (Object)update.getValueAfter()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.getUpdateMode().name());
                        }
                    }
                }

                public void close() throws IOException, IndexEntryConflictException {
                }

                public void remove(Iterable<Long> nodeIds) {
                    throw new UnsupportedOperationException("not expected");
                }
            };
        }

        public void setJob(IndexPopulationJob job) {
            this.job = job;
        }
    }

    private static class ControlledStoreScan
    implements StoreScan<RuntimeException> {
        private final DoubleLatch latch = new DoubleLatch();

        private ControlledStoreScan() {
        }

        public void run() {
            this.latch.startAndAwaitFinish();
        }

        public void stop() {
            this.latch.finish();
        }
    }
}

