/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.index.ControlledPopulationSchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class IndexRestartIt {
    private GraphDatabaseAPI db;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private TestGraphDatabaseFactory factory;
    private final ControlledPopulationSchemaIndexProvider provider = new ControlledPopulationSchemaIndexProvider();
    private final Label myLabel = DynamicLabel.label((String)"MyLabel");

    @Test
    public void shouldBeAbleToDropIndexWhileItIsPopulating() throws Exception {
        this.startDb();
        DoubleLatch populationCompletionLatch = this.provider.installPopulationJobCompletionLatch();
        IndexDefinition index = this.createIndex();
        populationCompletionLatch.awaitStart();
        this.dropIndex(index, populationCompletionLatch);
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(0)));
        try {
            Neo4jMatchers.getIndexState((GraphDatabaseService)this.db, index);
            Assert.fail((String)"This index should have been deleted");
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)this.myLabel.name()));
        }
    }

    @Test
    public void shouldHandleRestartOfOnlineIndex() throws Exception {
        this.startDb();
        this.createIndex();
        this.provider.awaitFullyPopulated();
        this.stopDb();
        this.provider.setInitialIndexState(InternalIndexState.ONLINE);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.ONLINE)));
        Assert.assertEquals((long)1L, (long)this.provider.populatorCallCount.get());
        Assert.assertEquals((long)2L, (long)this.provider.writerCallCount.get());
    }

    @Test
    public void shouldHandleRestartIndexThatHasNotComeOnlineYet() throws Exception {
        this.startDb();
        this.createIndex();
        this.stopDb();
        this.provider.setInitialIndexState(InternalIndexState.POPULATING);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Matchers.not(Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.FAILED))));
        Assert.assertEquals((long)2L, (long)this.provider.populatorCallCount.get());
    }

    private void startDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        this.db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
    }

    private void stopDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Before
    public void before() throws Exception {
        this.factory = new TestGraphDatabaseFactory();
        this.factory.setFileSystem(this.fs.get());
        this.factory.addKernelExtensions(Arrays.asList(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("test", this.provider)));
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    private IndexDefinition createIndex() {
        Transaction tx = this.db.beginTx();
        IndexDefinition index = this.db.schema().indexFor(this.myLabel).on("number_of_bananas_owned").create();
        tx.success();
        tx.finish();
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(IndexDefinition index, DoubleLatch populationCompletionLatch) {
        Transaction tx = this.db.beginTx();
        try {
            index.drop();
            populationCompletionLatch.finish();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

