/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;

public class IndexUpdaterMapTest {
    private IndexMap indexMap;
    private IndexProxy indexProxy1;
    private IndexDescriptor indexDescriptor1;
    private IndexUpdater indexUpdater1;
    private IndexProxy indexProxy2;
    private IndexDescriptor indexDescriptor2;
    private IndexUpdaterMap updaterMap;

    @Before
    public void before() throws IOException {
        this.indexMap = new IndexMap();
        this.indexProxy1 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.indexDescriptor1 = new IndexDescriptor(2, 3);
        this.indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy1.getDescriptor()).thenReturn((Object)this.indexDescriptor1);
        Mockito.when((Object)this.indexProxy1.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.indexUpdater1);
        this.indexProxy2 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.indexDescriptor2 = new IndexDescriptor(5, 6);
        IndexUpdater indexUpdater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy2.getDescriptor()).thenReturn((Object)this.indexDescriptor2);
        Mockito.when((Object)this.indexProxy2.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)indexUpdater2);
        this.updaterMap = new IndexUpdaterMap(IndexUpdateMode.ONLINE, this.indexMap);
    }

    @Test
    public void shouldRetrieveUpdaterFromIndexMapForExistingIndex() throws Exception {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        IndexUpdater updater = this.updaterMap.getUpdater(this.indexDescriptor1);
        Assert.assertEquals((Object)this.indexUpdater1, (Object)updater);
        Assert.assertEquals((long)1L, (long)this.updaterMap.size());
    }

    @Test
    public void shouldRetrieveSameUpdaterFromIndexMapForExistingIndexWhenCalledTwice() throws Exception {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        IndexUpdater updater1 = this.updaterMap.getUpdater(this.indexDescriptor1);
        IndexUpdater updater2 = this.updaterMap.getUpdater(this.indexDescriptor1);
        Assert.assertEquals((Object)updater1, (Object)updater2);
        Assert.assertEquals((long)1L, (long)this.updaterMap.size());
    }

    @Test
    public void shouldRetrieveNoUpdaterForNonExistingIndex() throws Exception {
        IndexUpdater updater = this.updaterMap.getUpdater(this.indexDescriptor1);
        Assert.assertNull((Object)updater);
        Assert.assertTrue((String)"updater map must be empty", (boolean)this.updaterMap.isEmpty());
    }

    @Test
    public void shouldCloseAllUpdaters() throws Exception {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        this.indexMap.putIndexProxy(1L, this.indexProxy2);
        IndexUpdater updater1 = this.updaterMap.getUpdater(this.indexDescriptor1);
        IndexUpdater updater2 = this.updaterMap.getUpdater(this.indexDescriptor2);
        this.updaterMap.close();
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
        Assert.assertTrue((String)"updater map must be empty", (boolean)this.updaterMap.isEmpty());
    }
}

