/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.xa.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.AwaitAnswer;

public class IndexingServiceTest {
    @Rule
    public final LifeRule life = new LifeRule();
    private int labelId;
    private int propertyKeyId;
    private IndexPopulator populator;
    private SchemaIndexProvider indexProvider;
    private IndexUpdater updater;
    private IndexAccessor accessor;
    private IndexStoreView storeView;

    @Before
    public void setUp() {
        this.labelId = 7;
        this.propertyKeyId = 15;
        this.populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        this.updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        this.indexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        this.accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        this.storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    }

    @Test
    public void shouldBringIndexOnlineAndFlipOverToIndexAccessor() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]));
        this.life.start();
        indexingService.startIndexes();
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)this.labelId, (int)this.propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        IndexProxy proxy = indexingService.getProxyForRule(0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((int)1000))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void indexCreationShouldBeIdempotent() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]));
        this.life.start();
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)this.labelId, (int)this.propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)this.labelId, (int)this.propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
    }

    @Test
    public void shouldDeliverUpdatesThatOccurDuringPopulationToPopulator() throws Exception {
        Mockito.when((Object)this.populator.newPopulatingUpdater((PropertyAccessor)this.storeView)).thenReturn((Object)this.updater);
        CountDownLatch latch = new CountDownLatch(1);
        ((IndexPopulator)Mockito.doAnswer(AwaitAnswer.afterAwaiting(latch)).when((Object)this.populator)).add(Matchers.anyLong(), Matchers.any());
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(this.add(1L, "value1")));
        this.life.start();
        indexingService.startIndexes();
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)this.labelId, (int)this.propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        IndexProxy proxy = indexingService.getProxyForRule(0L);
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(2L, "value2"));
        }
        latch.countDown();
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((int)1000))).close(true);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).add(1L, (Object)"value1");
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater((PropertyAccessor)this.storeView);
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).verifyDeferredConstraints((PropertyAccessor)this.storeView);
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater((PropertyAccessor)this.storeView);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(2L, "value2"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updater});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.accessor});
    }

    @Test
    public void shouldStillReportInternalIndexStateAsPopulatingWhenConstraintIndexIsDonePopulating() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]));
        this.life.start();
        indexingService.startIndexes();
        indexingService.createIndex(IndexRule.constraintIndexRule((long)0L, (int)this.labelId, (int)this.propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, null));
        IndexProxy proxy = indexingService.getProxyForRule(0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((int)1000))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void shouldBringConstraintIndexOnlineWhenExplicitlyToldTo() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]));
        this.life.start();
        indexingService.startIndexes();
        indexingService.createIndex(IndexRule.constraintIndexRule((long)0L, (int)this.labelId, (int)this.propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, null));
        IndexProxy proxy = indexingService.getProxyForRule(0L);
        indexingService.activateIndex(0L);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
    }

    @Test
    public void shouldLogIndexStateOnInit() throws Exception {
        TestLogger logger = new TestLogger();
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(provider);
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexingService indexingService = new IndexingService((JobScheduler)Mockito.mock(JobScheduler.class), (SchemaIndexProviderMap)providerMap, (IndexStoreView)Mockito.mock(IndexStoreView.class), mockLookup, (UpdateableSchemaState)Mockito.mock(UpdateableSchemaState.class), IndexingServiceTest.mockLogging(logger), IndexingService.NO_MONITOR);
        IndexRule onlineIndex = IndexRule.indexRule((long)1L, (int)1, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule populatingIndex = IndexRule.indexRule((long)2L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule failedIndex = IndexRule.indexRule((long)3L, (int)2, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(onlineIndex.getId())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex.getId())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex.getId())).thenReturn((Object)InternalIndexState.FAILED);
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        indexingService.initIndexes(Arrays.asList(onlineIndex, populatingIndex, failedIndex).iterator());
        logger.assertExactly(TestLogger.LogCall.info("IndexingService.initIndexes: index on :LabelOne(propertyOne) is ONLINE"), TestLogger.LogCall.info("IndexingService.initIndexes: index on :LabelOne(propertyTwo) is POPULATING"), TestLogger.LogCall.info("IndexingService.initIndexes: index on :LabelTwo(propertyTwo) is FAILED"));
    }

    @Test
    public void shouldLogIndexStateOnStart() throws Exception {
        TestLogger logger = new TestLogger();
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(provider);
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexingService indexingService = new IndexingService((JobScheduler)Mockito.mock(JobScheduler.class), (SchemaIndexProviderMap)providerMap, (IndexStoreView)Mockito.mock(IndexStoreView.class), mockLookup, (UpdateableSchemaState)Mockito.mock(UpdateableSchemaState.class), IndexingServiceTest.mockLogging(logger), IndexingService.NO_MONITOR);
        IndexRule onlineIndex = IndexRule.indexRule((long)1L, (int)1, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule populatingIndex = IndexRule.indexRule((long)2L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule failedIndex = IndexRule.indexRule((long)3L, (int)2, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getInitialState(onlineIndex.getId())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex.getId())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex.getId())).thenReturn((Object)InternalIndexState.FAILED);
        indexingService.initIndexes(Arrays.asList(onlineIndex, populatingIndex, failedIndex).iterator());
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        logger.clear();
        indexingService.startIndexes();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).getPopulationFailure(3L);
        logger.assertAtLeastOnce(TestLogger.LogCall.info("IndexingService.start: index on :LabelOne(propertyOne) is ONLINE"));
        logger.assertAtLeastOnce(TestLogger.LogCall.info("IndexingService.start: index on :LabelOne(propertyTwo) is POPULATING"));
        logger.assertAtLeastOnce(TestLogger.LogCall.info("IndexingService.start: index on :LabelTwo(propertyTwo) is FAILED"));
    }

    @Test
    public void shouldFailToStartIfMissingIndexProvider() throws Exception {
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), (IndexAccessor)Mockito.mock(IndexAccessor.class), new DataUpdates(new NodePropertyUpdate[0]));
        String otherProviderKey = "something-completely-different";
        SchemaIndexProvider.Descriptor otherDescriptor = new SchemaIndexProvider.Descriptor(otherProviderKey, "no-version");
        IndexRule rule = IndexRule.indexRule((long)1L, (int)2, (int)3, (SchemaIndexProvider.Descriptor)otherDescriptor);
        try {
            indexing.initIndexes(IteratorUtil.iterator((Object)rule));
            Assert.fail((String)"initIndexes with mismatching index provider should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"existing index"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)otherProviderKey));
        }
    }

    @Test
    public void shouldSnapshotOnlineIndexes() throws Exception {
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), indexAccessor, new DataUpdates(new NodePropertyUpdate[0]));
        int indexId = 1;
        int indexId2 = 2;
        File theFile = new File("Blah");
        IndexRule rule1 = IndexRule.indexRule((long)indexId, (int)2, (int)3, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)indexId2, (int)4, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(this.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId2)).thenReturn((Object)InternalIndexState.ONLINE);
        indexing.initIndexes(IteratorUtil.iterator((Object[])new IndexRule[]{rule1, rule2}));
        this.life.start();
        ResourceIterator files = indexing.snapshotStoreFiles();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterator)files), (Matcher)org.hamcrest.Matchers.equalTo((Object)IteratorUtil.asCollection((Iterator)IteratorUtil.iterator((Object[])new File[]{theFile, theFile}))));
    }

    @Test
    public void shouldNotSnapshotPopulatingIndexes() throws Exception {
        CountDownLatch populatorLatch = new CountDownLatch(1);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, indexAccessor, new DataUpdates(new NodePropertyUpdate[0]));
        int indexId = 1;
        int indexId2 = 2;
        File theFile = new File("Blah");
        IndexRule rule1 = IndexRule.indexRule((long)indexId, (int)2, (int)3, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)indexId2, (int)4, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        ((IndexPopulator)Mockito.doAnswer((Answer)this.waitForLatch(populatorLatch)).when((Object)this.populator)).create();
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(this.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId2)).thenReturn((Object)InternalIndexState.ONLINE);
        indexing.initIndexes(IteratorUtil.iterator((Object[])new IndexRule[]{rule1, rule2}));
        this.life.start();
        indexing.startIndexes();
        ResourceIterator files = indexing.snapshotStoreFiles();
        populatorLatch.countDown();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterator)files), (Matcher)org.hamcrest.Matchers.equalTo((Object)IteratorUtil.asCollection((Iterator)IteratorUtil.iterator((Object)theFile))));
    }

    @Test
    public void shouldIgnoreActivateCallDuringRecovery() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]));
        this.life.start();
        indexingService.activateIndex(0L);
    }

    private Answer waitForLatch(final CountDownLatch latch) {
        return new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                latch.await();
                return null;
            }
        };
    }

    private Answer<ResourceIterator<File>> newResourceIterator(final File theFile) {
        return new Answer<ResourceIterator<File>>(){

            public ResourceIterator<File> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object)theFile));
            }
        };
    }

    private static Logging mockLogging(StringLogger logger) {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)logging.getMessagesLog((Class)Matchers.any(Class.class))).thenReturn((Object)logger);
        return logging;
    }

    private NodePropertyUpdate add(long nodeId, Object propertyValue) {
        return NodePropertyUpdate.add((long)nodeId, (int)this.propertyKeyId, (Object)propertyValue, (long[])new long[]{this.labelId});
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data) throws IOException {
        StringLogger logger = (StringLogger)Mockito.mock(StringLogger.class);
        UpdateableSchemaState schemaState = (UpdateableSchemaState)Mockito.mock(UpdateableSchemaState.class);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class))).thenReturn((Object)populator);
        data.getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class))).thenReturn((Object)accessor);
        Mockito.when((Object)this.indexProvider.snapshotMetaFiles()).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant()).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        return (IndexingService)this.life.add(new IndexingService((JobScheduler)this.life.add(new Neo4jJobScheduler(logger)), (SchemaIndexProviderMap)new DefaultSchemaIndexProviderMap(this.indexProvider), this.storeView, (TokenNameLookup)Mockito.mock(TokenNameLookup.class), schemaState, IndexingServiceTest.mockLogging(logger), IndexingService.NO_MONITOR));
    }

    private DataUpdates withData(NodePropertyUpdate ... updates) {
        return new DataUpdates(updates);
    }

    private static class DataUpdates
    implements Answer<StoreScan<RuntimeException>>,
    Iterable<NodePropertyUpdate> {
        private final NodePropertyUpdate[] updates;

        DataUpdates(NodePropertyUpdate[] updates) {
            this.updates = updates;
        }

        void getsProcessedByStoreScanFrom(IndexStoreView mock) {
            Mockito.when((Object)mock.visitNodesWithPropertyAndLabel((IndexDescriptor)Matchers.any(IndexDescriptor.class), DataUpdates.visitor(Matchers.any(Visitor.class)))).thenAnswer((Answer)this);
        }

        public StoreScan<RuntimeException> answer(InvocationOnMock invocation) throws Throwable {
            final Visitor<NodePropertyUpdate, RuntimeException> visitor = DataUpdates.visitor(invocation.getArguments()[1]);
            return new StoreScan<RuntimeException>(){

                public void run() {
                    for (NodePropertyUpdate update : DataUpdates.this.updates) {
                        visitor.visit((Object)update);
                    }
                }

                public void stop() {
                }
            };
        }

        private static Visitor<NodePropertyUpdate, RuntimeException> visitor(Object v) {
            return (Visitor)v;
        }

        @Override
        public Iterator<NodePropertyUpdate> iterator() {
            return new ArrayIterator((Object[])this.updates);
        }

        public String toString() {
            return Arrays.toString(this.updates);
        }
    }
}

