/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.xa.PropertyRecordChange;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class PropertyPhysicalToLogicalConverterTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private PropertyStore store;
    private final String longString = "my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiing";
    private final String longerString = "my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiingdd";
    private PropertyPhysicalToLogicalConverter converter;
    private final long[] none = new long[0];

    @Test
    public void shouldConvertInlinedAddedProperty() throws Exception {
        long key = 10L;
        int value = 12345;
        PropertyRecord before = this.propertyRecord(new PropertyBlock[0]);
        PropertyRecord after = this.propertyRecord(this.property(key, value));
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, this.change(before, after)));
        Assert.assertEquals((Object)UpdateMode.ADDED, (Object)update.getUpdateMode());
    }

    @Test
    public void shouldConvertInlinedChangedProperty() throws Exception {
        long key = 10L;
        int valueBefore = 12341;
        int valueAfter = 738;
        PropertyRecord before = this.propertyRecord(this.property(key, valueBefore));
        PropertyRecord after = this.propertyRecord(this.property(key, valueAfter));
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, this.change(before, after)));
        Assert.assertEquals((Object)UpdateMode.CHANGED, (Object)update.getUpdateMode());
    }

    @Test
    public void shouldIgnoreInlinedUnchangedProperty() throws Exception {
        long key = 10L;
        int value = 12341;
        PropertyRecord before = this.propertyRecord(this.property(key, value));
        PropertyRecord after = this.propertyRecord(this.property(key, value));
        Assert.assertEquals((long)0L, (long)IteratorUtil.count(this.convert(this.none, this.none, this.change(before, after))));
    }

    @Test
    public void shouldConvertInlinedRemovedProperty() throws Exception {
        long key = 10L;
        int value = 12341;
        PropertyRecord before = this.propertyRecord(this.property(key, value));
        PropertyRecord after = this.propertyRecord(new PropertyBlock[0]);
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, this.change(before, after)));
        Assert.assertEquals((Object)UpdateMode.REMOVED, (Object)update.getUpdateMode());
    }

    @Test
    public void shouldConvertDynamicAddedProperty() throws Exception {
        long key = 10L;
        PropertyRecord before = this.propertyRecord(new PropertyBlock[0]);
        PropertyRecord after = this.propertyRecord(this.property(key, "my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiing"));
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, this.change(before, after)));
        Assert.assertEquals((Object)UpdateMode.ADDED, (Object)update.getUpdateMode());
    }

    @Test
    public void shouldConvertDynamicChangedProperty() throws Exception {
        long key = 10L;
        PropertyRecord before = this.propertyRecord(this.property(key, "my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiing"));
        PropertyRecord after = this.propertyRecord(this.property(key, "my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiingdd"));
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, this.change(before, after)));
        Assert.assertEquals((Object)UpdateMode.CHANGED, (Object)update.getUpdateMode());
    }

    @Test
    public void shouldConvertDynamicInlinedRemovedProperty() throws Exception {
        long key = 10L;
        PropertyRecord before = this.propertyRecord(this.property(key, "my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiing"));
        PropertyRecord after = this.propertyRecord(new PropertyBlock[0]);
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, this.change(before, after)));
        Assert.assertEquals((Object)UpdateMode.REMOVED, (Object)update.getUpdateMode());
    }

    @Test
    public void shouldTreatPropertyThatMovedToAnotherRecordAsChange() throws Exception {
        long key = 12L;
        String oldValue = "value1";
        String newValue = "value two";
        PropertyRecordChange movedFrom = this.change(this.propertyRecord(this.property(key, oldValue)), this.propertyRecord(new PropertyBlock[0]));
        PropertyRecordChange movedTo = this.change(this.propertyRecord(new PropertyBlock[0]), this.propertyRecord(this.property(key, newValue)));
        NodePropertyUpdate update = (NodePropertyUpdate)IteratorUtil.single(this.convert(this.none, this.none, movedFrom, movedTo));
        Assert.assertEquals((Object)UpdateMode.CHANGED, (Object)update.getUpdateMode());
        Assert.assertEquals((Object)oldValue, (Object)update.getValueBefore());
        Assert.assertEquals((Object)newValue, (Object)update.getValueAfter());
    }

    private PropertyRecord propertyRecord(PropertyBlock ... propertyBlocks) {
        PropertyRecord record = new PropertyRecord(0L);
        if (propertyBlocks != null) {
            record.setInUse(true);
            for (PropertyBlock propertyBlock : propertyBlocks) {
                record.addPropertyBlock(propertyBlock);
            }
        }
        return record;
    }

    private PropertyBlock property(long key, Object value) {
        PropertyBlock block = new PropertyBlock();
        this.store.encodeValue(block, (int)key, value);
        return block;
    }

    @Before
    public void before() throws Exception {
        StoreFactory storeFactory = new StoreFactory(new Config(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, (RemoteTxHook)new DefaultTxHook());
        File storeFile = new File("propertystore");
        storeFactory.createPropertyStore(storeFile);
        this.store = storeFactory.newPropertyStore(storeFile);
        this.converter = new PropertyPhysicalToLogicalConverter(this.store);
    }

    @After
    public void after() throws Exception {
        this.store.close();
    }

    private Iterable<NodePropertyUpdate> convert(long[] labelsBefore, long[] labelsAfter, PropertyRecordChange change) {
        return this.convert(labelsBefore, labelsAfter, new PropertyRecordChange[]{change});
    }

    private Iterable<NodePropertyUpdate> convert(long[] labelsBefore, long[] labelsAfter, PropertyRecordChange ... changes) {
        ArrayList<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();
        this.converter.apply(updates, Iterables.iterable((Object[])changes), labelsBefore, labelsAfter);
        return updates;
    }

    private PropertyRecordChange change(final PropertyRecord before, final PropertyRecord after) {
        return new PropertyRecordChange(){

            public PropertyRecord getBefore() {
                return before;
            }

            public PropertyRecord getAfter() {
                return after;
            }
        };
    }
}

