/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;

class HashBasedIndex
extends InMemoryIndexImplementation {
    private final Map<Object, Set<Long>> data = new HashMap<Object, Set<Long>>();

    HashBasedIndex() {
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    void clear() {
        this.data.clear();
    }

    @Override
    PrimitiveLongIterator doLookup(Object propertyValue) {
        Set<Long> nodes = this.data.get(propertyValue);
        return nodes == null ? PrimitiveLongCollections.emptyIterator() : PrimitiveLongCollections.toPrimitiveIterator(nodes.iterator());
    }

    @Override
    void doAdd(Object propertyValue, long nodeId, boolean applyIdempotently) {
        Set<Long> nodes = this.data.get(propertyValue);
        if (nodes == null) {
            nodes = new HashSet<Long>();
            this.data.put(propertyValue, nodes);
        }
        nodes.add(nodeId);
    }

    @Override
    void doRemove(Object propertyValue, long nodeId) {
        Set<Long> nodes = this.data.get(propertyValue);
        if (nodes != null) {
            nodes.remove(nodeId);
        }
    }

    @Override
    void remove(long nodeId) {
        for (Set<Long> nodes : this.data.values()) {
            nodes.remove(nodeId);
        }
    }

    @Override
    void iterateAll(InMemoryIndexImplementation.IndexEntryIterator iterator) throws Exception {
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            iterator.visitEntry(entry.getKey(), entry.getValue());
        }
    }

    public long maxCount() {
        return this.ids().size();
    }

    public Iterator<Long> iterator() {
        return this.ids().iterator();
    }

    private Collection<Long> ids() {
        HashSet<Long> allIds = new HashSet<Long>();
        for (Set<Long> someIds : this.data.values()) {
            allIds.addAll(someIds);
        }
        return allIds;
    }

    @Override
    InMemoryIndexImplementation snapshot() {
        HashBasedIndex snapshot = new HashBasedIndex();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            snapshot.data.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return snapshot;
    }

    public int getIndexedCount(long nodeId, Object propertyValue) {
        Set<Long> canditates = this.data.get(propertyValue);
        return canditates != null && canditates.contains(nodeId) ? 1 : 0;
    }
}

